// LISTING 3.4. Wstrzyknięcie i użycie komponentu ChangeHistoryManager

import com.atlassian.jira.component.ComponentAccessor;

// 1. Wstrzyknięcie komponentu UpdateHistoryAccessor.
def changeHistoryManager = ComponentAccessor.getChangeHistoryManager();

// 2. Pobranie obiektu typu interfejsowego Issue przykładowego zgłoszenia.
def issue = ComponentAccessor.getIssueManager().getIssueObject("BP1-3");

// 3. Pobranie historii zgłoszenia o kluczu BP1-3.
def issueChangeHistories = changeHistoryManager.getChangeHistories(issue);

// 4. Sformatowanie wyników do wyświetlenia.
String result = "";

issueChangeHistories.eachWithIndex {
    issueChangeHistory, index ->
        result += issueChangeHistory.getTimePerformed().toString() + " | " + issueChangeHistory.getAuthorDisplayName() + " | " + issueChangeHistory.getChangeItems();
        if (issueChangeHistories.size()-1>index)
            result += "<br />";
};

// 5. Wyświetlenie wyników.
/*
2022-07-09 04:41:55.481 | jkowalski | [[newvalue:JIRAUSER10100, field:reporter, oldstring:Adam
Malinowski, newstring:Jan Nowak, id:10601, fieldtype:jira, oldvalue:JIRAUSER10000, group:10601]]
2022-07-11 03:47:54.606 | jkowalski | [[newvalue:10100, field:Attachment, oldstring:null,
newstring:rysunek_3_12.png, id:10700, fieldtype:jira, oldvalue:null, group:10700]]
2022-07-11 03:48:02.462 | jkowalski | [[newvalue:10101, field:Attachment, oldstring:null,
newstring:rysunek_3_8.png, id:10701, fieldtype:jira, oldvalue:null, group:10701]]
*/
return result;