// LISTING 3.17. Wstrzyknięcie i użycie komponentu UserManager

import com.atlassian.jira.user.UserDetails;
import com.atlassian.jira.component.ComponentAccessor;

// 1. Wstrzyknięcie komponentu UserManager.
def userManager = ComponentAccessor.getUserManager();

// 2. Pobranie obiektu typu interfejsowego ApplicationUser dowolnego użytkownika Jiry.
def user = userManager.getUserByName("jnowak");

// 3. Utworzenie nowego użytkownika.
def newUserDetails = new UserDetails("jsmith", "John Smith").withEmail("example@example.com");
def newUser = userManager.createUser(newUserDetails);

// 4. Aktualizacja danych użytkownika.
// Istnieje możliwość użycia metody userManager.updateUser(<obiekt typu interfejsowego ApplicationUser>), 
// natomiast lepiej do tej operacji użyć interfejsu UserService opisanego w kolejnym rozdziale.

// 5. Pobranie obiektów wszystkich grup użytkowników z Jiry.
// UWAGA! Metoda przestarzała.
def allGroups = userManager.getAllGroups();

// 6. Pobranie obiektów wszystkich użytkowników z Jiry.
// UWAGA! Metoda przestarzała.
def allUsers = userManager.getGroups();