// LISTING 2.5. Synchronizacja metod

import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.component.ComponentAccessor;

// 1. Pobranie obiektu typu interfejsowego Issue zgłoszenia i rzutowanie do typu MutableIssue.
MutableIssue issue = ComponentAccessor.getIssueManager().getIssueObject("<klucz>");

// 2. Wykonanie kolejnych funkcji z obiektem typu interfejsowego MutableIssue jako parametrem.

// Utworzenie sub-tasków w zgłoszeniu.
createSubtasks(issue);

// Wykonanie jakiejś czynności na nowo utworzonych sub-taskach w zgłoszeniu.
doSomethingInSubtasks(issue);

// 3. Synchronizowane metody.
synchronized def createSubtask(MutableIssue issue) {
    // Utworzenie sub-tasku w przekazanym obiekcie typu interfejsowego Issue.
};

synchronized def doSomethingInSubtasks(MutableIssue issue) {
    issue.getSubTaskObjects().each() {
        // Wykonanie jakichś operacji na sub-tasku.
    }
};