// LISTING 26.3. Tworzenie nowego obiektu w bazie Insight

import com.atlassian.jira.component.ComponentAccessor;
import com.onresolve.scriptrunner.runner.customisers.WithPlugin;
@WithPlugin("com.riadalabs.jira.plugins.insight")

// 1. Pobranie komponentu IQLFacade.
Class iqlFacadeClass = ComponentAccessor.getPluginAccessor().getClassLoader().loadClass("com.riadalabs.jira.plugins.insight.channel.external.api.facade.IQLFacade");
def iqlFacade = ComponentAccessor.getOSGiComponentInstanceOfType(iqlFacadeClass) as com.riadalabs.jira.plugins.insight.channel.external.api.facade.IQLFacade;

// 2. Pobranie komponentu ObjectFacade.
Class objectFacadeClass = ComponentAccessor.getPluginAccessor().getClassLoader().loadClass("com.riadalabs.jira.plugins.insight.channel.external.api.facade.ObjectFacade");
def objectFacade = ComponentAccessor.getOSGiComponentInstanceOfType(objectFacadeClass) as com.riadalabs.jira.plugins.insight.channel.external.api.facade.ObjectFacade;

// 3. Pobranie komponentu ObjectTypeAttributeFacade.
Class objectTypeAttributeFacadeClass = ComponentAccessor.getPluginAccessor().getClassLoader().loadClass("com.riadalabs.jira.plugins.insight.channel.external.api.facade.ObjectTypeAttributeFacade");
def objectTypeAttributeFacade = ComponentAccessor.getOSGiComponentInstanceOfType(objectTypeAttributeFacadeClass) as com.riadalabs.jira.plugins.insight.channel.external.api.facade.ObjectTypeAttributeFacade;

// 4. Pobranie komponentu ObjectTypeFacade.
Class objectTypeFacadeClass = ComponentAccessor.getPluginAccessor().getClassLoader().loadClass("com.riadalabs.jira.plugins.insight.channel.external.api.facade.ObjectTypeFacade");
def objectTypeFacade = ComponentAccessor.getOSGiComponentInstanceOfType(objectTypeFacadeClass) as com.riadalabs.jira.plugins.insight.channel.external.api.facade.ObjectTypeFacade;

// 5. Pobranie komponentu ObjectAttributeBeanFactory.
Class objectAttributeBeanFactoryClass = ComponentAccessor.getPluginAccessor().getClassLoader().loadClass("com.riadalabs.jira.plugins.insight.services.model.factory.ObjectAttributeBeanFactory");
def objectAttributeBeanFactory = ComponentAccessor.getOSGiComponentInstanceOfType(objectAttributeBeanFactoryClass) as com.riadalabs.jira.plugins.insight.services.model.factory.ObjectAttributeBeanFactory;

// 6. Inicjalizacja nowego ObjectBean dla tworzonego obiektu Insight.

// 6.1. Pobranie ObjectTypeBean dla object type Absences o identyfikatorze 4.
def absencesObjectTypeBean = objectTypeFacade.loadObjectTypeBean(4);

// 6.2. Inicjalizacja nowego ObjectBean dla object type Absences.
def newAbsencesObjectBean = absencesObjectTypeBean.createMutableObjectBean();

// 7. Inicjalizacja listy do przechowywania kolejnych atrybutów.
def objectAttributeBeans = new ArrayList();

// 8. Nadanie wartości poszczególnym atrybutom i dodanie do listy objectAttributeBeans.

// 8.1. Atrybut Name o identyfikatorze 14.
def nameObjectTypeAttributeBean = objectTypeAttributeFacade.loadObjectTypeAttributeBean(14);
objectAttributeBeans.add(objectAttributeBeanFactory.createObjectAttributeBeanForObject(newAbsencesObjectBean, nameObjectTypeAttributeBean,"Nieobecność"));

// 8.2. Atrybut Employee o identyfikatorze 22.
def employeeObjectTypeAttributeBean = objectTypeAttributeFacade.loadObjectTypeAttributeBean(22).createMutable();
def employeeObjectBeanToAdd = iqlFacade.findObjectsByIQLAndSchema(1, "objectType = Employees and \"Name\" = \"Alana Grant\"").get(0);
def newRelatedBranchObjectAttributeBean = objectAttributeBeanFactory.createObjectAttributeBeanForObject(newAbsencesObjectBean, employeeObjectTypeAttributeBean, employeeObjectBeanToAdd.getName());
objectAttributeBeans.add(newRelatedBranchObjectAttributeBean);

// 8.3. Atrybut Deputy o identyfikatorze 23.
def deputyObjectTypeAttributeBean = objectTypeAttributeFacade.loadObjectTypeAttributeBean(23).createMutable();
def deputyObjectBeanToAdd = iqlFacade.findObjectsByIQLAndSchema(1, "objectType = Employees and \"Name\" = \"Mitch Davis\"").get(0);
def newRelatedDeputyObjectAttributeBean = objectAttributeBeanFactory.createObjectAttributeBeanForObject(newAbsencesObjectBean,deputyObjectTypeAttributeBean,deputyObjectBeanToAdd.getName());
objectAttributeBeans.add(newRelatedDeputyObjectAttributeBean);

// 8.4. Atrybut Absence start date o identyfikatorze 24.
def absenceStartDateObjectTypeAttributeBean = objectTypeAttributeFacade.loadObjectTypeAttributeBean(24);
objectAttributeBeans.add(objectAttributeBeanFactory.createObjectAttributeBeanForObject(newAbsencesObjectBean, absenceStartDateObjectTypeAttributeBean,"2022-07-01"));

// 8.5. Atrybut Absence end date o identyfikatorze 25.
def absenceEndDateObjectTypeAttributeBean = objectTypeAttributeFacade.loadObjectTypeAttributeBean(25);
objectAttributeBeans.add(objectAttributeBeanFactory.createObjectAttributeBeanForObject(newAbsencesObjectBean, absenceEndDateObjectTypeAttributeBean,"2022-07-07"));

// 9. Dodanie listy utworzonych atrybutów do ObjectBean.
newAbsencesObjectBean.setObjectAttributeBeans(objectAttributeBeans);

// 10. Zapisanie obiektu do bazy Insight.
try {
    newAbsencesObjectBean = objectFacade.storeObjectBean(newAbsencesObjectBean);
} catch (Exception e) {
    log.warn("Something went wrong: " + e.getMessage());
}