// LISTING 25.2. Wyświetlenie zrzutowanej listy atrybutów obiektu Insighta

import com.atlassian.jira.component.ComponentAccessor;

// 1. Pobranie zgłoszenia z uzupełnionymi wartościami custom fieldów.
def issue = ComponentAccessor.getIssueManager().getIssueObject("CM-1");

// 2. Pobranie obiektu typu interfejsowego CustomField.
def branchesField = ComponentAccessor.getCustomFieldManager().getCustomFieldObject(10400L);

// 3. Pobranie wartości custom fieldów ze zgłoszenia.
def branchesFieldValue = issue.getCustomFieldValue(branchesField);

// 4. Wyświetlenie zrzutowanej do Stringa listy atrybutów.
// [ObjectAttributeBean [objectTypeAttributeId=5, objectId=1], ObjectAttributeBean
// [objectTypeAttributeId=6, objectId=1],
// ObjectAttributeBean [objectTypeAttributeId=7, objectId=1], ObjectAttributeBean
// [objectTypeAttributeId=8, objectId=1],
// ObjectAttributeBean [objectTypeAttributeId=27, objectId=1]]
return String.join("<br />", branchesFieldValue.getAt(0).getObjectAttributeBeans().collect() {it.toString()});