// LISTING 22.6. Utworzenie nowej strony w wybranej przestrzeni Confluence

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.application.confluence.ConfluenceApplicationType;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.sal.api.net.ResponseHandler;
import groovy.json.JsonBuilder;
import groovy.json.JsonSlurper;

// 1. Inicjalizacja ApplicationLink.
def ApplicationLink getPrimaryConfluenceLink() {
    def applicationLinkService = ComponentLocator.getComponent(ApplicationLinkService);
    final ApplicationLink confluenceApplicationLink = applicationLinkService.getPrimaryApplicationLink(ConfluenceApplicationType);
    return confluenceApplicationLink;
}

// 2. Inicjalizacja fabryczki do wysyłania żądań przez Confluence API.
def confluenceLink = getPrimaryConfluenceLink();
def authenticatedRequestFactory = confluenceLink.createImpersonatingAuthenticatedRequestFactory();

// 3. Inicjalizacja mapy podstawowych parametrów do utworzenia strony.
def createPageRequestBody = [
    type: "page",
    title: "New page 2",
    space: [
        key: "SMP2"
    ],
    body: [
        storage: [
            value: "Sample content",
            representation: "storage"
        ]
    ]
];

// 4. Wykonanie operacji tworzenia strony w Confluence.
def newPageId;
authenticatedRequestFactory
    .createRequest(Request.MethodType.POST, "rest/api/content")
    .addHeader("Content-Type", "application/json")
    .setRequestBody(new JsonBuilder(createPageRequestBody).toString())
    .execute(new ResponseHandler<Response>() {

        @Override
        void handle(Response response) throws ResponseException {
            if (response.statusCode != HttpURLConnection.HTTP_OK) {
                throw new Exception(response.getResponseBodyAsString())
            } else {
                newPageId = new JsonSlurper().parseText(response.responseBodyAsString)["id"];
                log.info "Page ${newPageId} has been created.";
            }
        }
    });