// LISTING 19.8. Utworzenie projektu

// 1. Token użytkownika.
def token = "OTUxODQxMjc3ODIwOs8GGxW31/mPWMI9gH0UqLp+OQRq";

// 2. URI endpointa Jira REST API.
def url = "http://172.16.117.141:8080/rest/api/2/project";

// 3. Zainicjowanie ciała zapytania.

// 3.1. Zdefiniowanie szablonu projektu w polu projectTemplateKey.
// Dla Jira Software:
//      Scrum: com.pyxis.greenhopper.jira:gh-scrum-template.
//      Kanban: com.pyxis.greenhopper.jira:gh-kanban-template.
//      Basic: com.pyxis.greenhopper.jira:basic-software-development-template.
// Dla Jira Software Management:
//      Basic: com.atlassian.servicedesk:basic-service-desk-project.
//      IT Service Management: com.atlassian.servicedesk:itil-v2-service-desk-project.
//      Customer Service: com.atlassian.servicedesk:customer-service-desk-project.

// 3.2. Zdefiniowanie awatara w polu avatarId.
// Identyfikatory pobrane z ustawień Jiry.
// avatarId można podejrzeć w elemencie HTML-a na stronie konfiguracji projektu.
def jsonBody = """
{
    "key": "ITM",
    "name": "IT Management",
    "projectTypeKey": "software",
    "projectTemplateKey": "com.pyxis.greenhopper.jira:gh-scrum-template",
    "description": "Example Project description",
    "lead": "rlee-sd-demo",
    "url": "http://helion.pl",
    "assigneeType": "PROJECT_LEAD",
    "avatarId": 10200,
    "issueSecurityScheme": 10000,
    "permissionScheme": 10000,
    "notificationScheme": 10000,
    "workflowSchemeId": 10000,
    "categoryId": 10000
}
""";

// 4. Otwarcie połączenia z endpointem.
def connection = url.toURL().openConnection() as HttpURLConnection;

// 5. Dodanie parametrów połączenia.
connection.setRequestMethod("POST");
connection.addRequestProperty("Authorization", "Bearer " + token);
connection.addRequestProperty("X-Atlassian-Token", "no-check");
connection.setDoOutput(true);
connection.addRequestProperty("Content-Type", "application/json");
connection.getOutputStream().write(jsonBody.getBytes("UTF-8"))
connection.setReadTimeout(5000);
connection.connect();

// 6. Odpowiedź po wykonaniu żądania.
if (connection.getResponseCode()==201)
    println("Issue has been created");
else if (connection.getErrorStream()!=null)
    println(connection.getErrorStream().getText());

// 7. Zamknięcie połączenia.
connection.disconnect();