// LISTING 16.4. Wykonanie złożonego przejścia za pomocą komponentu WorkflowTransitionUtil

import com.atlassian.jira.util.JiraUtils;
import com.atlassian.jira.workflow.WorkflowTransitionUtilImpl;
import com.atlassian.jira.workflow.WorkflowTransitionUtil;
import com.atlassian.jira.component.ComponentAccessor;

// 1. Pobranie obiektu typu interfejsowego Issue zgłoszenia, na którym będzie wykonywane przejście.
def issue = ComponentAccessor.getIssueManager().getIssueObject("WT-2");

// 2. Pobranie obiektu typu interfejsowego ApplicationUser użytkownika wykonującego przejście.
def adminUser = ComponentAccessor.getUserManager().getUserByName("kwascow");

// 3. Pobranie komponentu WorkflowTransitionUtil.
def workflowTransitionUtil = (WorkflowTransitionUtil) JiraUtils.loadComponent("com.atlassian.jira.workflow.WorkflowTransitionUtilImpl", WorkflowTransitionUtilImpl.class);

// 4. Ustawienie zgłoszenia, na którym ma zostać wykonane przejście.
workflowTransitionUtil.setIssue(issue);

// 5. Ustawienie klucza użytkownika realizującego przejście.
workflowTransitionUtil.setUserkey(adminUser.getKey());

// 6. Ustawienie identyfikatora wykonywanego przejścia.
// Numer 41 oznacza przejście ze statusu To Do do In Progress.
workflowTransitionUtil.setAction(41);

// 7. Utworzenie mapy parametrów z danymi zgłoszenia.
Map params = new HashMap();

// 7.1. Dodanie komentarza.
params.put("comment", "Some comment");

// 7.2. Zmiana resolution i custom fieldu o identyfikatorze 10115.
// Uwaga! Opcja może nie działać w niektórych wersjach Jiry.
params.put("resolution", 10001);
params.put("10115", "Some text");

// 7.3. Dodanie parametrów do konfiguracji przejścia.
workflowTransitionUtil.setParams(params);

// 8. Walidacja przejścia.
workflowTransitionUtil.validate();

// 9. Wykonanie przejścia.
workflowTransitionUtil.progress();