// LISTING 15.7. Zmiana szczegółów wersji

import java.text.SimpleDateFormat;
import com.atlassian.jira.component.ComponentAccessor;

// 1. Pobranie menedżerów.
def versionManager = ComponentAccessor.getVersionManager();

// 2. Pobranie wersji Version 3 o identyfikatorze 10203.
def versionToEdit = versionManager.getVersion(10203L);

// 3. Aktualizacja wersji w obiekcie.

// Deklaracja i inicjalizacja zmiennych start date i release date.
def startDate = new SimpleDateFormat("yyyy-MM-dd").parse("2022-08-02");
def releaseDate = new SimpleDateFormat("yyyy-MM-dd").parse("2022-08-15");

// Modyfikacja nazwy i opisu wersji, a następnie przypisanie zmodyfikowanego obiektu do zmiennej versionToEdit.
versionToEdit = versionManager.editVersionDetails(versionToEdit, "Version 3 fixed", "Sample description fixed");

// Zmiana start date, a następnie przypisanie zmodyfikowanego obiektu do zmiennej versionToEdit.
versionToEdit = versionManager.editVersionStartDate(versionToEdit, startDate);

// Zmiana release date.
versionManager.editVersionReleaseDate(versionToEdit, releaseDate);