// LISTING 15.1. Pobieranie komponentów ze zgłoszenia

import com.atlassian.jira.component.ComponentAccessor;

// 1. Pobranie obiektu typu interfejsowego Issue ze zdefiniowanymi komponentami.
def issue = ComponentAccessor.getIssueManager().getIssueObject("SKX-4");

// 2. Pobranie menedżerów.
def issueManager = ComponentAccessor.getIssueManager();

// 3. Pobranie danych o komponentach ze zgłoszenia za pomocą pętli each().
def result1 = "";
issue.getComponents().each {
    component ->
        result1 += "component | ";
        result1 += "componentName: " + component.getName() + ", ";
        result1 += "componentLead: " + component.getComponentLead() + ", ";
        result1 += "componentId: " + component.getId();
        result1 += "<br />";
};

// 4. Pobranie danych o komponentach ze zgłoszenia za pomocą metody collect().
def result2 = issue.getComponents().collect() {
    component -> 
        "component | componentName: ${component.getName()}, componentLead: ${component.getComponentLead()}, componentId: ${component.getId()}"
};
result2 = String.join("<br />", result2);

// 5. Pobranie komponentu za pomocą identyfikatora.
def result3 = ComponentAccessor.getProjectComponentManager().getProjectComponent(10004L);
result3 = result3.getName();

// 6. Wyświetlenie wyników.
/* component | componentName: Moduł integracji z systemami zewnętrznymi,
componentLead: awisniewski(JIRAUSER10300), componentId: 10002 component | componentName:
Moduł ksiąg rachunkowych, componentLead: mkonopnicka(JIRAUSER10102), componentId: 10001
component | componentName: Moduł integracji z systemami zewnętrznymi, componentLead:
awisniewski(JIRAUSER10300), componentId: 10002 component | componentName: Moduł ksiąg
rachunkowych, componentLead: mkonopnicka(JIRAUSER10102), componentId: 10001
Moduł integracji z systemami zewnętrznymi*/
return "${result1}${result2}<br />${result3}";