// LISTING 13.7. Tworzenie sub-tasków dla zgłoszeń z listy

import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.IssueInputParameters;

// 1. Pobranie listy wszystkich tasków z projektu o nazwie Zadania Cykliczne Działu Wsparcia.
def issueManager = ComponentAccessor.getIssueManager();
def parentIssues = issueManager.getIssueObjects(issueManager.getIssueIdsForProject(10200));

// 2. Wybranie tylko tych tasków, które nie mają sub-tasków.
parentIssues = parentIssues.findAll() {
    parentIssue ->
        !parentIssue.isSubTask() && parentIssue.getSubTaskObjects().isEmpty()
};

// 3. Utworzenie trzech sub-tasków w każdym tasku z listy.
parentIssues.each() {
    parentIssue ->
        createSubTask(parentIssue as MutableIssue, "Kolejka systemu A");
        createSubTask(parentIssue as MutableIssue, "Kolejka systemu B");
        createSubTask(parentIssue as MutableIssue, "Kolejka systemu C");
};

// 4. Funkcja zawierająca kod tworzący pojedynczy sub-task.
// Jako argumenty przyjmuje obiekt typu interfejsowego MutableIssue tasku i Summary nowo tworzonego sub-tasku.
def createSubTask(MutableIssue issue, String summary) {

    // 4.1. Pobranie komponentów IssueService i IssueInputParameters.
    def issueService = ComponentAccessor.getIssueService();
    IssueInputParameters inputParameters = issueService.newIssueInputParameters();

    // 4.2. Uzupełnienie parametrów za pomocą interfejsu IssueInputParameters.
    // issueTypeId == 10003 => Story.
    inputParameters
        .setProjectId(issue.getProjectId())
        .setSummary(summary)
        .setIssueTypeId("10003")
        // Operator obiektowy został zastosowany w celu zabezpieczenia przed pobieraniem nazwy użytkownika, jeżeli zgłoszenie jest nieprzypisane.
        .setAssigneeId(issue.getAssignee()?.getName())
        // Przypisanie wartości domyślnych do parametrów, jeżeli nie zostały zdefiniowane.
        .setApplyDefaultValuesWhenParameterNotProvided(true);

    // 4.3. Walidacja parametrów sub-tasku za pomocą użytkownika będącego reporterem.
    def subTaskValidationResult = issueService.validateSubTaskCreate(issue.reporter, issue.getId(), inputParameters);

    // 4.4. Utworzenie sub-tasku za pomocą użytkownika będącego reporterem.
    def subTaskManager = ComponentAccessor.getSubTaskManager();
    def subTask = issueService.create(issue.reporter, subTaskValidationResult);

    // 4.5. Podlinkowanie nowo utworzonego sub-tasku z taskiem.
    subTaskManager.createSubTaskIssueLink(issue, subTask.getIssue(), issue.getReporterUser());
}