// LISTING 13.6. Utworzenie sub-tasku po utworzeniu zgłoszenia nadrzędnego

import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.IssueInputParameters;

/* (Opcja 1) 1. Utworzenie zgłoszenia w sposób przedstawiony w listingu 13.5.
[…]
def createIssueResult = issueService.create(adminUser, createValidationResult);
// Możliwość pobrania obiektu typu interfejsowego Issue nowo utworzonego zgłoszenia.
// Na tym zgłoszeniu będzie wykonywana operacja utworzenia sub-tasku.
// Przed przystąpieniem do dalszego działania należy zrzutować obiekt typu interfejsowego Issue
// do MutableIssue, aby umożliwić jego późniejszą edycję.
// def issue = createIssueResult.getIssue() as MutableIssue;
*/

// (Opcja 2) 1. Ręczne pobranie zgłoszenia.
// Zmienna techniczna pozwalająca na uruchomienie skryptu dla dowolnego zgłoszenia.
def issue = ComponentAccessor.getIssueManager().getIssueObject("ZCDW-11") as MutableIssue;

// 2. Utworzenie trzech sub-tasków w zgłoszeniu.
createSubTask(issue, "Kolejka systemu A");
createSubTask(issue, "Kolejka systemu B");
createSubTask(issue, "Kolejka systemu C");

// 3. Metoda zawierająca kod tworzący pojedynczy sub-task.
// Jako argumenty przyjmuje obiekt typu interfejsowego MutableIssue zgłoszenia nadrzędnego i Summary nowo tworzonego sub-tasku.
def createSubTask(MutableIssue issue, String summary) {

    // 3.1. Pobranie komponentów IssueService i IssueInputParameters.
    def issueService = ComponentAccessor.getIssueService();
    IssueInputParameters inputParameters = issueService.newIssueInputParameters();

    // 3.2. Uzupełnienie parametrów za pomocą interfejsu IssueInputParameters.
    // issueTypeId == 10003 => Story.
    inputParameters
        .setProjectId(issue.getProjectId())
        .setSummary(summary)
        .setIssueTypeId("10003")
        .setAssigneeId(issue.getAssignee().getName())
        // Przypisanie wartości domyślnych do parametrów, jeżeli nie zostały zdefiniowane.
        .setApplyDefaultValuesWhenParameterNotProvided(true);

    // 3.3. Walidacja parametrów sub-tasku za pomocą użytkownika będącego reporterem.
    def subTaskValidationResult = issueService.validateSubTaskCreate(issue.reporter, issue.getId(), inputParameters);

    // 3.4. Utworzenie sub-tasku za pomocą użytkownika będącego reporterem.
    def subTaskManager = ComponentAccessor.getSubTaskManager();
    def subTask = issueService.create(issue.reporter, subTaskValidationResult);

    // 3.5. Podlinkowanie nowo utworzonego sub-tasku ze zgłoszeniem nadrzędnym.
    subTaskManager.createSubTaskIssueLink(issue, subTask.getIssue(), issue.getReporterUser());
}