// LISTING 13.5. Utworzenie zgłoszenia ze zdefiniowanymi wartościami custom fieldów

import org.apache.commons.lang3.ArrayUtils;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.IssueInputParameters;
import java.time.temporal.WeekFields;
import java.time.DayOfWeek;

// 1. Pobranie obiektu typu interfejsowego ApplicationUser administratora.
def adminUser = ComponentAccessor.getUserManager().getUserByName("admin");

// 2. Pobranie użytkownika do Assignee w zależności od dnia tygodnia.

// Pobranie daty bieżącej.
def dateNow = new Date();

// Ustawienie poniedziałku jako pierwszego dnia tygodnia.
WeekFields weekFields = WeekFields.of(DayOfWeek.MONDAY, 1);

// Ustawienie użytkownika Assignee.
ApplicationUser assignee;
if (dateNow.toLocalDate().get(weekFields.dayOfWeek())<=2)
    assignee = ComponentAccessor.getUserManager().getUserByName("anowak");
else
    assignee = ComponentAccessor.getUserManager().getUserByName("jkowalski");

// 3. Pobranie numeru telefonu Assignee z User property danego użytkownika.
UserPropertyManager userPropertyManager = ComponentAccessor.getUserPropertyManager();
String[] phoneNumber = ArrayUtils.toArray(userPropertyManager.getPropertySet(assignee).getString('jira.meta.Phone'));

// 4. Utworzenie listy użytkowników dla pola Permitted users.
String[] permittedUsers = [
ComponentAccessor.getUserManager().getUserByName("wlukasinski").getUsername(),
ComponentAccessor.getUserManager().getUserByName("kbranicki").getUsername()
];

// 5. Inicjalizacja obiektu z nazwą wybranej opcji w polu Case category.
// Metoda addCustomFieldValue() wymaga wskazania id i wartości opcji.
// W przypadku select list (multiple choices) do tablicy dodaje się kolejne pary identyfikator – nazwa opcji.
String[] caseCategory = ["10500", "S5 Zadania własne"];

// 6. Pobranie obiektów typu interfejsowego CustomField, których wartości będą dodawane do nowo tworzonego zgłoszenia.
def contactField = ComponentAccessor.getCustomFieldManager().getCustomFieldObject(10800L);
def permittedUsersField = ComponentAccessor.getCustomFieldManager().getCustomFieldObject(10502L);
def caseCategoryField = ComponentAccessor.getCustomFieldManager().getCustomFieldObject(10200L);

// 7. Pobranie komponentów IssueService i IssueInputParameters.
def issueService = ComponentAccessor.getIssueService();
IssueInputParameters inputParameters = issueService.newIssueInputParameters();

// 8. Uzupełnienie parametrów za pomocą interfejsu IssueInputParameters.
// projectId == 10200 => Zadania Cykliczne Działu Wsparcia.
// issueTypeId == 10001 => Story.
inputParameters
    .setProjectId(10200)
    .setIssueTypeId("10001")
    .setSummary("Przegląd kolejki zgłoszeń użytkowników - ${dateNow.getDateString()}")
    .setReporterId(adminUser.getName())
    .setAssigneeId(assignee.getName())
    .setDescription("1. Zaloguj się do Jiry.\n2. Przydziel nieprzypisane zgłoszenia do operatorów. \n3. Wyślij powiadomienia.")
    // Dodanie wartości do custom fieldu typu text field (single line).
    .addCustomFieldValue(contactField.getId(), phoneNumber)
    // Dodanie użytkowników do custom fieldu typu user picker (multiple users).
    .addCustomFieldValue(permittedUsersField.getId(), permittedUsers)
    // Wybranie opcji S5 Zadania własne do custom fieldu typu select list (single choice).
    .addCustomFieldValue(caseCategoryField.getId(), caseCategory);

// 9. Walidacja parametrów zgłoszenia za pomocą użytkownika admin.
def createValidationResult = issueService.validateCreate(adminUser, inputParameters);

// 10. Utworzenie zgłoszenia za pomocą użytkownika admin.
// Metoda create zwraca obiekt IssueService.IssueResult.
def createIssueResult = issueService.create(adminUser, createValidationResult);

// 11. Możliwość pobrania obiektu typu interfejsowego Issue nowo utworzonego zgłoszenia.
// Osoby dodające wartości custom fieldów drugą metodą mają możliwość wykonania operacji na poniższym obiekcie.
def issue = createIssueResult.getIssue();