// LISTING 12.9. Pobranie wartości z custom fieldu typu select list (multiple choices)

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.customfields.option.LazyLoadedOption;
import java.lang.String;

// 1. Pobranie menedżerów.
def issueManager = ComponentAccessor.getIssueManager();
def customFieldManager = ComponentAccessor.getCustomFieldManager();

// 2. Pobranie przykładowego zgłoszenia według klucza.
def issue = issueManager.getIssueObject("ZDZ-1");

// 3. Pobranie obiektu implementującego CustomField.
def impactField = customFieldManager.getCustomFieldObject(10300L);

// 4. Pobranie listy wybranych opcji custom fieldu ze zgłoszenia i rzutowanie do listy obiektów LazyLoadedOption.
def impactFieldValues = issue.getCustomFieldValue(impactField) as ArrayList<LazyLoadedOption>;

// 5. (Opcja 1) Załadowanie nazw i identyfikatorów opcji do obiektu String za pomocą pętli eachWithIndex().
String resultFromLoop = "";
impactFieldValues.eachWithIndex {
    impactFieldValue, index ->
        resultFromLoop += "${impactFieldValue.getValue()} (${impactFieldValue.getOptionId()})";
    
        // Dodanie separatora.
        if (index < (impactFieldValues.size()-1)) resultFromLoop += ", ";
}

// 6. (Opcja 2) Załadowanie nazw i identyfikatorów opcji do obiektu String za pomocą metody String.join().
String resultToString = String.join(", ", impactFieldValues.collect(){"${it.getValue()} (${it.getOptionId()})"});

// 7. Zwrócenie wyników.
// Infrastruktura serwerowa (10209), Systemy dostawców zewnętrznych (10211).
return "${resultFromLoop}<br />${resultToString}";