// LISTING 12.5. Wykorzystanie wartości select list (single choice) w wyrażeniach warunkowych

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.customfields.option.LazyLoadedOption;

// 1. Pobranie menedżerów.
def issueManager = ComponentAccessor.getIssueManager();
def customFieldManager = ComponentAccessor.getCustomFieldManager();

// 2. Pobranie przykładowego zgłoszenia według klucza.
def issue = issueManager.getIssueObject("ZSS-1");

// 3. Pobranie obiektu implementującego CustomField i wartość custom fieldu ze zgłoszenia.
def budgetPlanField = customFieldManager.getCustomFieldObject(10114L);
def budgetPlanFieldValue = issue.getCustomFieldValue(budgetPlanField) as LazyLoadedOption;

// 4. Deklaracja zmiennych dla wyników.
boolean result1, result2, result3;

// 5. Porównanie nazwy wybranej opcji.

// Porównanie nazwy wybranej opcji w składni Javy.
if (budgetPlanFieldValue.getValue().equals("BG-67 Promocja ZSS")) result1 = true;
else result1 = false;

// Porównanie nazwy wybranej opcji w składni Groovy’ego.
// (!) Operator == jest tożsamy z metodą equals() w Groovym.
if (budgetPlanFieldValue.getValue() == "BG-67 Promocja ZSS") result2 = true;
else result2 = false;

// Porównanie identyfikatora wybranej opcji w składni Groovy’ego i Javy.
if (budgetPlanFieldValue.getOptionId() == 10007) result3 = true;
else result3 = false;

// 6. Wyświetlenie wyników.
// result1: true | result2: true | result3: true
return "result1: ${result1} | result2: ${result2} | result3: ${result3}";