// LISTING 12.4. Pobieranie wartości custom fieldu typu select list (single choice)

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.customfields.option.LazyLoadedOption;

// 1. Pobranie menedżerów.
def issueManager = ComponentAccessor.getIssueManager();
def customFieldManager = ComponentAccessor.getCustomFieldManager();

// 2. Pobranie przykładowego zgłoszenia według klucza.
def issue = issueManager.getIssueObject("ZSS-1");

// 3. Pobranie obiektu implementującego CustomField.
def budgetPlanField = customFieldManager.getCustomFieldObject(10114L);

// 4. Pobranie obiektu opcji custom fieldu ze zgłoszenia.

// Rzutowanie obiektu opcji do typu LazyLoadedOption w Groovym.
def budgetPlanFieldValue1 = issue.getCustomFieldValue(budgetPlanField) as LazyLoadedOption;

// Rzutowanie obiektu opcji do typu LazyLoadedOption w Javie.
LazyLoadedOption budgetPlanFieldValue2 = (LazyLoadedOption) issue.getCustomFieldValue(budgetPlanField);

// Pobranie obiektu opcji — w zależności od wersji Jiry/ScriptRunnera/JMWE może być zwrócony typ Object lub LazyLoadedOption.
def budgetPlanFieldValue3 = issue.getCustomFieldValue(budgetPlanField);

// 5. Pobieranie wartości lub identyfikatora opcji.

// Pobranie identyfikatora opcji z obiektu LazyLoadedOption.
def bpfv1OptionId = budgetPlanFieldValue1.getOptionId();

// Pobranie nazwy opcji z obiektu LazyLoadedOption.
def bpfv1OptionValue1 = budgetPlanFieldValue2.getValue();

// Pobranie nazwy przez rzutowanie obiektu do String.
def bpfv1OptionValue2 = budgetPlanFieldValue3 as String;

// 6. Wyświetlenie wyników.
// bpfv1OptionId: 10007 | bpfv1OptionValue1: BG-67 Promocja ZSS | bpfv1OptionValue2 BG-67 Promocja ZSS
return "bpfv1OptionId: ${bpfv1OptionId} | bpfv1OptionValue1: ${bpfv1OptionValue1} | bpfv1OptionValue2 ${bpfv1OptionValue2}";