// LISTING 12.18. Wyświetlenie w polu Payment check date wartości wyliczonej na podstawie pola Invoice date

import com.atlassian.jira.component.ComponentAccessor;
import java.sql.Timestamp;
import java.time.temporal.WeekFields;
import java.time.DayOfWeek;

// 1. Pobranie obiektu implementującego CustomField dla pola Invoice date.
def invoiceDateField = ComponentAccessor.getCustomFieldManager().getCustomFieldObject(10602L);

// 2. Pobranie wartości pola Invoice date.
def invoiceDateFieldValue = issue.getCustomFieldValue(invoiceDateField) as Timestamp;

// 3. Dodanie 14 dni do daty z pola Invoice date.
def invoiceDateFieldValueIncreased = invoiceDateFieldValue.plus(14);

// 4. Ustawienie poniedziałku jako pierwszego dnia tygodnia.
WeekFields weekFields = WeekFields.of(DayOfWeek.MONDAY, 1);

// 5. Ustawienie daty i godziny końcowej.
def dayOfWeek = invoiceDateFieldValueIncreased.toLocalDateTime().get(weekFields.dayOfWeek());

// Ustawienie godziny 12.00 dla piątku.
if (dayOfWeek==5) {
    invoiceDateFieldValueIncreased.setHours(12)

// Przesunięcie daty na najbliższy poniedziałek, jeżeli data wypada w sobotę lub w niedzielę.
} else if (dayOfWeek>5) {
    invoiceDateFieldValueIncreased = invoiceDateFieldValueIncreased.plus(8-dayOfWeek);
    invoiceDateFieldValueIncreased.setHours(15);

// Ustawienie godziny 15.00 dla daty od poniedziałku do czwartku.
} else {
    invoiceDateFieldValueIncreased.setHours(15);
}

// 6. Zwrócenie wartości Payment check date.
return invoiceDateFieldValueIncreased;