// LISTING 12.15. Przetwarzanie i edycja obiektów w user picker i group picker

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.user.DelegatingApplicationUser;
import com.atlassian.crowd.embedded.impl.ImmutableGroup;
import com.atlassian.jira.bc.user.UserService;

// 1. Pobranie menedżerów.
def issueManager = ComponentAccessor.getIssueManager();
def customFieldManager = ComponentAccessor.getCustomFieldManager();

// 2. Pobranie przykładowego zgłoszenia według klucza.
def issue = issueManager.getIssueObject("ZSS-1");

// 3. Pobranie obiektów implementujących CustomField.

// User picker (single user).
def managerField = customFieldManager.getCustomFieldObject(10501L);

// User picker (multiple users).
def permittedUsersField = customFieldManager.getCustomFieldObject(10502L);

// Group picker (single group).
def supervisorsField = customFieldManager.getCustomFieldObject(10503L);

// Group picker (multiple groups).
def permittedGroupsField = customFieldManager.getCustomFieldObject(10504L);

// 4. Pobranie wartości custom fieldów ze zgłoszenia.

// DelegatingApplicationUser implementuje interfejs com.atlassian.jira.user.ApplicationUser.
def managerFieldValue = issue.getCustomFieldValue(managerField) as DelegatingApplicationUser;
def permittedUsersFieldValue = issue.getCustomFieldValue(permittedUsersField) as ArrayList<DelegatingApplicationUser>;

// Oba typy group picker przechowują wartości jako obiekt ArrayList<ImmutableGroup>.
def supervisorsFieldValue = issue.getCustomFieldValue(supervisorsField) as ArrayList<ImmutableGroup>;
def permittedGroupsFieldValue = issue.getCustomFieldValue(permittedGroupsField) as ArrayList<ImmutableGroup>;

// 5. Sprawdzenie, czy dowolny użytkownik jest członkiem grupy zapisanej w group picker (single group).
def user1 = ComponentAccessor.getUserManager().getUserByName("anowak");
def isUserInGroup1 = ComponentAccessor.getGroupManager() .isUserInGroup(user1, supervisorsFieldValue.get(0));

// 6. Sprawdzenie, czy Assignee jest członkiem którejkolwiek z grup zapisanych w group picker (multiple groups).
def user2 = issue.getAssignee();
def isUserInGroup2 = permittedGroupsFieldValue.any() {
    group ->
        ComponentAccessor.getGroupManager().isUserInGroup(user2, group)
};

// 7. Pobranie wszystkich użytkowników przynależących do grupy.
def group1 = ComponentAccessor.getGroupManager().getGroup("jira-software-users");

// Lista użytkowników w postaci ArrayList<DelegatingApplicationUser>.
def getUsersInGroup1 = ComponentAccessor.getGroupManager().getUsersInGroup("jira-software-users");
def getUsersInGroup2 = ComponentAccessor.getGroupManager().getUsersInGroup(group1);

// Lista nazw użytkowników (usernames) w postaci ArrayList<String>.
def getUsersInGroup3 = ComponentAccessor.getGroupManager().getUserNamesInGroup(group1);

// 8. Sprawdzenie, do jakich grup należy użytkownik.
def userGroupsList = ComponentAccessor.getGroupManager().getGroupsForUser(user1);
def userGroup1 = String.join(", ", userGroupsList.collect() {group -> group.getName()});

// 9. Dodanie użytkownika do grupy.

// Za pomocą komponentu GroupManager.
def group2 = ComponentAccessor.getGroupManager().getGroup("team2");
def user3 = ComponentAccessor.getUserManager().getUserByName("mkonopnicka");
ComponentAccessor.getGroupManager().addUserToGroup(user3, group2);

// Za pomocą komponentu UserUtil.
ComponentAccessor.getUserUtil().addUserToGroup(group2, user3);

// 10. Usunięcie użytkownika z grupy.

// Usunięcie z wybranej grupy.
ComponentAccessor.getUserUtil().removeUserFromGroup(group2, user3);

// Usunięcie użytkownika ze wszystkich grup poza jira-software-users.
def user4 = ComponentAccessor.getUserManager().getUserByName("anowak");
def groups1 = ComponentAccessor.getGroupManager().getGroupsForUser(user4);
def groupsToRemoveUser1 = groups1.findAll() {
    group -> !group.getName().equals("jira-software-users")
};
ComponentAccessor.getUserUtil().removeUserFromGroups(groupsToRemoveUser1, user4);

// 11. Dezaktywacja użytkownika.
// Uwaga! Opcja może nie działać we wszystkich wersjach Jiry.
def user5 = ComponentAccessor.getUserManager().getUserByName("mkopernik");
def userService = ComponentAccessor.getComponent(UserService);
def userToUpdate1 = userService.newUserBuilder(user5).active(false).build();
def validationResult1 = userService.validateUpdateUser(userToUpdate1);
if (validationResult1.isValid()) userService.updateUser(validationResult1);
else log.warn "Update failed for ${user5}";

// 12. Aktywacja użytkownika.
// Uwaga! Opcja może nie działać we wszystkich wersjach Jiry.
def userToUpdate2 = userService.newUserBuilder(user5).active(true).build();
def validationResult2 = userService.validateUpdateUser(userToUpdate2)
if (validationResult2.isValid()) userService.updateUser(validationResult2)
else log.warn "Update failed for ${user5}";

// 13. Wyświetlenie wyników.
// userInGroup1: true | userInGroup2: false | getUsersInGroup1: [anowak(JIRAUSER10102),
// jkowalski(JIRAUSER10100), admin(JIRAUSER10000), mkonopnicka(JIRAUSER10103),
// mkopernik(JIRAUSER10101)] | getUsersInGroup2: [anowak(JIRAUSER10102), jkowalski
// (JIRAUSER10100), admin(JIRAUSER10000), mkonopnicka(JIRAUSER10103), mkopernik
// (JIRAUSER10101)] | getUsersInGroup3: [anowak, jkowalski, kwascow, mkonopnicka, mkopernik] |
// userGroup1: jira-software-users, supervisors
return "userInGroup1: ${isUserInGroup1} | userInGroup2: ${isUserInGroup2} | getUsersInGroup1: ${getUsersInGroup1} | getUsersInGroup2: ${getUsersInGroup2} | getUsersInGroup3: ${getUsersInGroup3} | userGroup1: ${userGroup1}";