// LISTING 12.14. Pobieranie danych z custom fieldów typu user picker i group picker

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.user.DelegatingApplicationUser;
import com.atlassian.crowd.embedded.impl.ImmutableGroup;

// 1. Pobranie menedżerów.
def issueManager = ComponentAccessor.getIssueManager();
def customFieldManager = ComponentAccessor.getCustomFieldManager();

// 2. Pobranie przykładowego zgłoszenia według klucza.
def issue = issueManager.getIssueObject("ZSS-1");

// 3. Pobranie obiektów implementujących CustomField.

// User picker (single user).
def managerField = customFieldManager.getCustomFieldObject(10501L);

// User picker (multiple users).
def permittedUsersField = customFieldManager.getCustomFieldObject(10502L);

// Group picker (single group).
def supervisorsField = customFieldManager.getCustomFieldObject(10503L);

// Group picker (multiple groups).
def permittedGroupsField = customFieldManager.getCustomFieldObject(10504L);

// 4. Pobranie wartości pól ze zgłoszenia.

// DelegatingApplicationUser implementuje interfejs com.atlassian.jira.user.ApplicationUser.
def managerFieldValue = issue.getCustomFieldValue(managerField) as DelegatingApplicationUser;
def permittedUsersFieldValue = issue.getCustomFieldValue(permittedUsersField) as ArrayList<DelegatingApplicationUser>;

// Oba typy group picker przechowują wartości jako obiekt ArrayList<ImmutableGroup>.
def supervisorsFieldValue = issue.getCustomFieldValue(supervisorsField) as ArrayList<ImmutableGroup>;
def permittedGroupsFieldValue = issue.getCustomFieldValue(permittedGroupsField) as ArrayList<ImmutableGroup>;

// 5. Pobranie szczegółów użytkownika.

// Nazwa użytkownika, wyświetlana nazwa, e-mail.
def singleUserName1 = managerFieldValue.getName();
def singleUserName2 = managerFieldValue.getUsername();
def singleUserDisplayName = managerFieldValue.getDisplayName();
def singleUserEmail = managerFieldValue.getEmailAddress();

// Identyfikator, klucz użytkownika.
def singleUserKey = managerFieldValue.getKey();
def singleUserId = managerFieldValue.getId();

// 6. Pobieranie użytkowników z user picker (multiple users).

// Przetwarzanie listy obiektów DelegatingApplicationUser w pętli ArrayList.each().
def multipleUsersList1 = "";
permittedUsersFieldValue.each {
    user ->
        multipleUsersList1 += "${user.getDisplayName()} (${user.getName()}) "
};

// Przetwarzanie listy obiektów DelegatingApplicationUser w pętli ArrayList.eachWithIndex().
def multipleUsersList2 = "";
permittedUsersFieldValue.eachWithIndex {
    user, index ->
        multipleUsersList2 += "${user.getDisplayName()} (${user.getName()})"
        if (index < (permittedUsersFieldValue.size()-1)) multipleUsersList2 += ", ";
};

// Załadowanie nazw i identyfikatorów opcji do obiektu String za pomocą metody String.join().
String multipleUsersList3 = String.join(", ", permittedUsersFieldValue.collect(){"${it.getDisplayName()} (${it.getName()})"});

// 7. Pobranie szczegółów grupy.

// Group picker (single group) — lista z tylko jedną wartością.
def groupName = supervisorsFieldValue.get(0).getName();

// Group picker (multiple groups).
def groupNames1 = String.join(", ", permittedGroupsFieldValue.collect(){"${it.getName()}"});
def groupNames2 = "";
permittedGroupsFieldValue.each { group -> groupNames2 += "${group.getName()} "};
def groupNames3 = "";
permittedGroupsFieldValue.eachWithIndex {
    group, index ->
        groupNames3 += "${group.getName()}"
        if (index < (permittedGroupsFieldValue.size()-1)) groupNames3 += ", ";
};

// 8. Wyświetlenie wyników.
// singleUserName1: anowak | singleUserName2: anowak | singleUserDisplayName: Adam Nowak |
// singleUserEmail: someAddress@example.com | singleUserKey: JIRAUSER10102 | sigleUserId:
// 10102 | multipleUsersList1 Maria Konopnicka (mkonopnicka) Mikołaj Kopernik (mkopernik) |
// multipleUsersList2: Maria Konopnicka (mkonopnicka), Mikołaj Kopernik (mkopernik) |
// multipleUsersList3: Maria Konopnicka (mkonopnicka), Mikołaj Kopernik (mkopernik) |
// groupName: supervisors | groupNames1: supervisors, team1, team2, team3 | groupNames2:
// supervisors team1 team2 team3 | groupNames3: supervisors, team1, team2, team3
return "singleUserName1: ${singleUserName1} | singleUserName2: ${singleUserName2} | singleUserDisplayName: ${singleUserDisplayName} | singleUserEmail: ${singleUserEmail} | singleUserKey: ${singleUserKey} | sigleUserId: ${singleUserId} | multipleUsersList1 ${multipleUsersList1} | multipleUsersList2: ${multipleUsersList2} | multipleUsersList3: ${multipleUsersList3} | groupName: ${groupName} | groupNames1: ${groupNames1} | groupNames2: ${groupNames2} | groupNames3: ${groupNames3}";