// LISTING 10.20. Klasa MyValidatorFactory z metodami do przetwarzania parametrów walidatora

package pl.helion.jira.workflow;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.StatusManager;
import com.atlassian.jira.plugin.webresource.JiraWebResourceManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.opensymphony.workflow.loader.AbstractDescriptor;
import com.opensymphony.workflow.loader.ValidatorDescriptor;
import com.atlassian.jira.plugin.workflow.AbstractWorkflowPluginFactory;
import com.atlassian.jira.plugin.workflow.WorkflowPluginValidatorFactory;
import javax.inject.Inject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * Klasa fabryki parametrów dla szablonów Velocity i metody validate() w klasie MyValidator.
 */
public class MyValidatorFactory extends AbstractWorkflowPluginFactory implements WorkflowPluginValidatorFactory {
    
    // 1. Deklaracja menedżera do zarządzania statycznymi elementami strony (resources).
    private JiraWebResourceManager jiraWebResourceManager;
    
    /**
     * 2. Konstruktor, który wstrzyknie obiekt typu interfejsowego JiraWebResourceManager.
     * @param jiraWebResourceManager
     */
    @Inject
    public MyValidatorFactory(@ComponentImport JiraWebResourceManager jiraWebResourceManager) {
        this.jiraWebResourceManager = jiraWebResourceManager;
    }
    
    /**
     * 3. Metoda pobiera dane dla formularza ustawień walidatora.
     * @param velocityParams — zbiór parametrów do modelu szablonu Velocity.
     */
    protected void getVelocityParamsForInput(Map velocityParams) {

        // 4. Inicjalizacja listy wszystkich dostępnych statusów w Jirze.
        StatusManager statusManager = ComponentAccessor.getComponent(StatusManager.class);
        List statuses = statusManager.getStatuses().stream().map(status -> status.getName()).collect(Collectors.toList());

        // 5. Przekazanie do modelu szablonu Velocity listy wszystkich dostępnych statusów w Jirze.
        velocityParams.put("statuses", statuses);

        // 6. Przekazanie do modelu obiektu menedżera w celu załadowania źródeł w szablonie Velocity.
        velocityParams.put("jiraWebResourceManager", jiraWebResourceManager);
    }
    
    /**
     * 7. Metoda zwraca aktualnie zapisane dane formularza ustawień walidatora do edycji.
     * @param velocityParams
     * @param descriptor
     */
    protected void getVelocityParamsForEdit(Map velocityParams, AbstractDescriptor descriptor) {
        getVelocityParamsForInput(velocityParams);
        getVelocityParamsForView(velocityParams, descriptor);
    }
    
    /**
     * 8. Metoda zwraca aktualnie zapisane dane formularza ustawień walidatora dla widoku.
     * @param velocityParams
     * @param descriptor
     */
    protected void getVelocityParamsForView(Map velocityParams, AbstractDescriptor descriptor) {
        if (!(descriptor instanceof ValidatorDescriptor))
            throw new IllegalArgumentException("Descriptor must be a ValidatorDescriptor.");
        
        ValidatorDescriptor validatorDescriptor = (ValidatorDescriptor)descriptor;
        velocityParams.put("subTaskStatus", validatorDescriptor.getArgs().get("subTaskStatus"));
    }
    
    /**
     * 9. Metoda zwraca aktualnie zapisane dane ustawień walidatora do wyświetlenia w liście
     * włączonych walidatorów.
     * @param validatorParams
     */
    public Map getDescriptorParams(Map validatorParams) {
        Map params = new HashMap();
        params.put("subTaskStatus", extractSingleParam(validatorParams, "subTaskStatus"));
        return params;
    }
}