// LISTING 3.5. Wstrzyknięcie i użycie komponentu CommentManager

import com.atlassian.jira.component.ComponentAccessor;

// 1. Wstrzyknięcie komponentu CommentManager.
def commentManager = ComponentAccessor.getCommentManager();

// 2. Pobranie obiektu typu interfejsowego Issue przykładowego zgłoszenia.
def issue = ComponentAccessor.getIssueManager().getIssueObject("BP1-3");

// 3. Pobranie obiektu typu interfejsowego ApplicationUser użytkownika z uprawnieniami do tworzenia komentarzy w projekcie.
def user = ComponentAccessor.getUserManager().getUserByName("admin");

// 4. Dodanie komentarza do zgłoszenia.
commentManager.create(issue, user, "some comment", true);

// 5. Sformatowanie informacji tekstowej o wszystkich komentarzach w zgłoszeniu.
String result = "";
commentManager.getComments(issue).each {
    comment ->
        result += comment.getCreated().getDateTimeString() + " | " + comment.getAuthorKey() + " | " + comment.getBody() + "<br />";
};

// 6. Wyświetlenie wyników.
/*
7/11/22 4:14:14 PM | JIRAUSER10104 | some comment
7/11/22 4:15:50 PM | JIRAUSER10104 | some comment 1
7/11/22 4:16:05 PM | JIRAUSER10000 | some comment 2
*/
return result;