// LISTING 3.12. Wstrzyknięcie i użycie komponentu PriorityManager

import com.atlassian.jira.config.PriorityManager;
import com.atlassian.jira.component.ComponentAccessor;

// 1. Wstrzyknięcie komponentu PriorityManager.
def priorityManager = ComponentAccessor.getComponent(PriorityManager);

// 2. Pobranie listy obiektów dostępnych priorytetów.
def priorities = priorityManager.getPriorities();

// 3. Utworzenie nowego priorytetu.
def newPriority = priorityManager.createPriority(
    "Medium rare",
    "some description",
    "/images/icons/priorities/trivial.png",
    "#ff0000"
);

// 4. Pobranie i edycja istniejącego priorytetu.
def priorityToEdit = priorityManager.getPriority("10000");
priorityManager.editPriority(
    priorityToEdit,
    "Medium rare 2",
    "some description 2",
    "/images/icons/priorities/trivial.png",
    "#AA0000"
);