// LISTING 25.6. Aktualizacja custom fieldu typu Insight object/s

import com.atlassian.jira.event.type.EventDispatchOption;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.component.ComponentAccessor;
import com.onresolve.scriptrunner.runner.customisers.WithPlugin;
@WithPlugin("com.riadalabs.jira.plugins.insight")

// 1. Pobranie komponentu ObjectFacade.
Class objectFacadeClass = ComponentAccessor.getPluginAccessor().getClassLoader().loadClass("com.riadalabs.jira.plugins.insight.channel.external.api.facade.ObjectFacade");
def objectFacade = ComponentAccessor.getOSGiComponentInstanceOfType(objectFacadeClass) as com.riadalabs.jira.plugins.insight.channel.external.api.facade.ObjectFacade;

// 2. Pobranie zgłoszenia z uzupełnionymi wartościami custom fieldów i zrzutowanie do typu MutableIssue.
def issue = ComponentAccessor.getIssueManager().getIssueObject("CM-2") as MutableIssue;

// 3. Pobranie obiektu typu interfejsowego ApplicationUser użytkownika do wykonania aktualizacji zgłoszenia.
def adminUser = ComponentAccessor.getUserManager().getUserByName("admin");

// 4. Pobranie obiektu typu interfejsowego CustomField i wartości ze zgłoszenia.
def allOperatorsField = ComponentAccessor.getCustomFieldManager().getCustomFieldObject(10500L);
def allOperatorsFieldValue = issue.getCustomFieldValue(allOperatorsField);

// 5. Dodanie obiektów Insighta do ArrayList pobranej z custom fieldu.
allOperatorsFieldValue.add(objectFacade.loadObjectBean("MCD-18"));
allOperatorsFieldValue.add(objectFacade.loadObjectBean("MCD-19"));

// 6. Aktualizacja wartości obiektu typu interfejsowego MutableIssue.
issue.setCustomFieldValue(allOperatorsField, allOperatorsFieldValue);

// 7. Wykonanie aktualizacji zgłoszenia.
ComponentAccessor.getIssueManager().updateIssue(adminUser, issue, EventDispatchOption.ISSUE_UPDATED, false);