// LISTING 25.4. Pobranie wartości atrybutu default z ObjectBean

import com.atlassian.jira.component.ComponentAccessor;

// 1. Pobranie zgłoszenia z uzupełnionymi wartościami custom fieldów.
def issue = ComponentAccessor.getIssueManager().getIssueObject("CM-1");

// 2. Pobranie obiektu typu interfejsowego CustomField i jego wartości ze zgłoszenia.
def operatorsField = ComponentAccessor.getCustomFieldManager().getCustomFieldObject(10402L);
def operatorsFieldValue = issue.getCustomFieldValue(operatorsField);

// 3. Pobranie etykiet obiektów Insighta.
def operatorLabels = "";
operatorsFieldValue.each {
    operator ->
        operatorLabels += operator.getLabel() + " | ";
};

// 4. Pobranie atrybutu z obiektu ObjectBean.

// Identyfikator atrybutu First name to 17.
def operatorAttributes = "";
operatorsFieldValue.each() {
    operator ->
        operatorAttributes += operator.getObjectAttributeBeans().find() {
            objectAttributeBean -> objectAttributeBean.getObjectTypeAttributeId()==17
        }?.getObjectAttributeValueBeans().get(0).getTextValue() + " | ";
};

// 5. Wyświetlenie wyników.
// objectLabels: Jennifer Evans | Ryan Lee |
// operatorAttributes: Jennifer | Ryan |
return "operatorLabels: ${operatorLabels} <br />operatorAttributes: ${operatorAttributes}";