// LISTING 25.1. Weryfikacja typów obiektów custom fieldu typu Insight object/s i Insight referenced object/s

import com.atlassian.jira.component.ComponentAccessor;

// 1. Pobranie zgłoszenia z uzupełnionymi wartościami custom fieldów.
def issue = ComponentAccessor.getIssueManager().getIssueObject("CM-1");

// 2. Pobranie obiektów typu interfejsowego CustomField.
def branchesField = ComponentAccessor.getCustomFieldManager().getCustomFieldObject(10400L);
def branchesFieldValue = issue.getCustomFieldValue(branchesField);

// 3. Pobranie wartości custom fieldów ze zgłoszenia.
def operatorsField = ComponentAccessor.getCustomFieldManager().getCustomFieldObject(10402L);
def operatorsFieldValue = issue.getCustomFieldValue(operatorsField);

// 4. Wyświetlenie wartości i nazw klas obiektów dla pierwszego obiektu z pola.
/*
branchesFieldValue: [IT (MCD-1)] | className1: java.util.ArrayList | className2: com.riadalabs.
jira.plugins.insight.services.model.ObjectBean | operatorsFieldValue: [Mitch Davis (MCD-18)] |
className3: java.util.ArrayList | className4: com.riadalabs.jira.plugins.insight.services.model.
ObjectBean
*/
return "branchesFieldValue: ${branchesFieldValue} | className1: ${branchesFieldValue.getClass().getName()} | className2: ${branchesFieldValue.getAt(0).getClass().getName()} | operatorsFieldValue: ${operatorsFieldValue} | className3: ${operatorsFieldValue.getClass().getName()} | className4: ${operatorsFieldValue.getAt(0).getClass().getName()}";