'LISTING 21.7. Makro do komunikacji z Jira REST API

Sub getJiraIssues()
    
    ' 1. Deklaracja zmiennych.
    Dim endpointUrl As String
    Dim jiraUserToken As String
    Dim xmlHttp As Object
    Dim jsonObject As Object
    Dim result As String
    
    ' 2. Dane dostępowe do Jira REST API.
    endpointUrl = "http://172.16.117.141:8080/rest/api/2/search?jql=project=test"
    jiraUserToken = "Njc0Nzk2OTA4MjM2OuvyeXGbojaXXYjCwAevamC8oDKO"

    ' 3. Inicjalizacja klienta do wykonania żądania REST.
    Set xmlHttp = CreateObject("MSXML2.serverXMLHTTP")

    ' 4. Wysłanie żądania.
    With xmlHttp
        .Open "GET", endpointUrl
        .SetRequestHeader "Content-Type", "application/json"
        .SetRequestHeader "Accept", "application/json"
        .SetRequestHeader "Authorization", "Bearer " & jiraUserToken
        .Send
    End With

    ' 5. Pobranie rezultatów zapytania i konwersja danych na obiekt JSON.
    result = xmlHttp.ResponseText
    Set json = JsonConverter.ParseJson(result)

    ' 6. Wygenerowanie wiersza z nagłówkami w arkuszu.
    Worksheets("Sheet1").Range("A1").Value = "issue_key"
    Worksheets("Sheet1").Range("B1").Value = "summary"
    Worksheets("Sheet1").Range("C1").Value = "status"

    ' 7. Przetworzenie obiektu JSON w pętli i wstawienie kolejnych wierszy dla zgłoszeń w arkuszu Excela.
    Dim index As Integer
    index = 2
    For Each Item In json("issues")
        Worksheets("Sheet1").Range("A" & index).Value = Item("key")
        Worksheets("Sheet1").Range("B" & index).Value = Item("fields")("summary")
        Worksheets("Sheet1").Range("C" & index).Value = Item("fields")("status")("name")
        index = index + 1
    Next Item
End Sub