// LISTING 19.1. Import zgłoszeń do pliku CSV
import org.json.*;

// 1. Token użytkownika.
def token = "OTUxODQxMjc3ODIwOs8GGxW31/mPWMI9gH0UqLp+OQRq";

// 2. URI endpointa Jira REST API.
def url = "http://172.16.117.141:8080/rest/api/2/search?jql=project%20=%20test%20and%20created%20%3E=%202022-07-14%20and%20created%20%3C=%202022-07-16%20and%20assignee%20is%20not%20EMPTY";

// 3. Otwarcie połączenia z endpointem.
def connection = url.toURL().openConnection() as HttpURLConnection;

// 4. Dodanie parametrów połączenia.
connection.addRequestProperty("Authorization", "Bearer " + token);
connection.addRequestProperty("X-Atlassian-Token", "no-check");
connection.addRequestProperty("Content-Type", "application/json");
connection.setRequestMethod("GET");
connection.setReadTimeout(5000);
connection.connect();

// 5. Przekształcenie wyniku ze Stringu do obiektu JSONArray z listą zgłoszeń.
String jsonString = connection.getInputStream().getText("UTF-8");
JSONObject jsonObject = new JSONObject(jsonString);
JSONArray docs = jsonObject.getJSONArray("issues");

// 6. Inicjalizacja BufferedWriter do zapisu danych w pliku.
BufferedWriter writer = new BufferedWriter(new FileWriter("test.csv", true));

// 7. Dodanie pierwszej linii w pliku CSV.
writer.append("issueKey;summary;status;assignee;created");
writer.newLine();

// 8. Przekształcenie obiektu JSONArray w listę ArrayList zawierającą rekordy zgłoszeń.
List<String> rows = docs.collect() {
    it ->
        (it as JSONObject).get("key") + ";" + 
        (it as JSONObject).getJSONObject("fields").get("summary") + ";" + 
        (it as JSONObject).getJSONObject("fields").getJSONObject("status").get("name") + ";" + 
        (it as JSONObject).getJSONObject("fields").getJSONObject("assignee").get("name") + ";" + 
        (it as JSONObject).getJSONObject("fields").get("created")
};

// 9. Dodanie wierszy zgłoszeń do pliku CSV.
writer.append(String.join("\n", rows));

// 10. Zamknięcie BufferedWriter.
writer.close();

// 11. Zamknięcie połączenia z API.
connection.disconnect();