// LISTING 16.5. Wykonanie złożonego przejścia za pomocą komponentu IssueService

import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.component.ComponentAccessor;

// 1. Pobranie obiektu typu interfejsowego Issue zgłoszenia, na którym będzie wykonywane przejście, i zrzutowanie go do MutableIssue.
def issue = ComponentAccessor.getIssueManager().getIssueObject("WT-4") as MutableIssue;

// 2. Pobranie obiektu typu interfejsowego ApplicationUser użytkownika wykonującego przejście.
def adminUser = ComponentAccessor.getUserManager().getUserByName("admin");

// 3. Pobranie komponentu IssueService.
def issueService = ComponentAccessor.getIssueService();

// 4. Inicjalizacja komponentu do ustawiania parametrów przejścia.
def issueInputParameters = issueService.newIssueInputParameters();

// 4.1. Ignorowanie błędów weryfikacji wartości w screenach.
issueInputParameters.setSkipScreenCheck(true);

// 4.2. Ustawienie rozwiązania zgłoszenia (resolution) na Done (identyfikator 10000).
issueInputParameters.setResolutionId("10000");

// 4.3. Zmiana Summary zgłoszenia.
issueInputParameters.setSummary("New summary");

// 4.4. Dodanie Description zgłoszenia.
issueInputParameters.setDescription("New description");

// 4.5. Zmiana osoby przypisanej do zgłoszenia.
def userToAssignee = ComponentAccessor.getUserManager().getUserByName("admin");
issueInputParameters.setAssigneeId(userToAssignee.getUsername());

// 4.6. Modyfikacja custom fieldu typu text field (single line) o identyfikatorze 10115.
issueInputParameters.addCustomFieldValue(10115L, "Some value");

// 4.7. Dodanie komentarza do zgłoszenia.
issueInputParameters.setComment("Some comment");

// 5. Walidacja przejścia.
// Jako trzeci parametr metody validateTransition() należy podać identyfikator przejścia, które ma zostać wykonane.
// W poniższym przypadku 61 oznacza przejście ze statusu In Progress do Done.
def validationResult = issueService.validateTransition(adminUser, issue.getId(), 61, issueInputParameters);

// 6. Wykonanie przejścia.
issueService.transition(adminUser, validationResult);