// LISTING 15.15. Zmiana parametrów projektu

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.project.UpdateProjectParameters;

// 1. Pobranie obiektu typu interfejsowego ApplicationUser użytkownika do aktualizacji project lead.
def projectLeadToAdd = ComponentAccessor.getUserManager().getUserByName("akowalski");

// 2. Pobranie menedżerów.
def projectManager = ComponentAccessor.getProjectManager();

// 3. Pobranie obiektu projektu po identyfikatorze.
def projectObject1 = projectManager.getProjectObj(10406);

// 4. Zdefiniowanie parametrów zmiany danych w projekcie.
def updateProjectParameters = UpdateProjectParameters
    .forProject(10406)
    .name("Business project")
    .description("Some new description")
    .leadUserKey(projectLeadToAdd.getKey())
    .url("http://example.com");

// 5. Zapisanie zmiany danych projektu.
projectManager.updateProject(updateProjectParameters);