// LISTING 13.2. Masowa zmiana wartości custom fieldu w zgłoszeniach i reindeksacja

import com.atlassian.jira.util.ImportUtils;
import com.atlassian.jira.issue.index.IssueIndexingService;
import com.atlassian.jira.issue.util.DefaultIssueChangeHolder;
import com.atlassian.jira.issue.ModifiedValue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.component.ComponentAccessor;

// 1. Pobranie obiektu DelegatingApplicationUser użytkownika admin do wykonania zmiany.
def adminUser = ComponentAccessor.getUserManager().getUserByName("admin");

// 2. Pobranie menedżerów i serwisów.
def issueManager = ComponentAccessor.getIssueManager();
def issueIndexingService = ComponentAccessor.getComponent(IssueIndexingService);

// 3. Pobranie obiektu typu interfejsowego CustomField, którego wartość będzie zmieniana.
def textDataField = ComponentAccessor.getCustomFieldManager().getCustomFieldObject(10200L);

// 4. Zdefiniowanie zmiennych do reindeksacji zgłoszeń.
Collection<String> ToReindex = [];
def issueToReindex;
def isIndexIssuesCurrentSettings;

// 5. Pobranie wszystkich zgłoszeń z projektu o nazwie Test project i przetworzenie ich w pętli each().
// projectId => 10100.
def projectIssues = issueManager.getIssueObjects(issueManager.getIssueIdsForProject(10100)) as ArrayList<MutableIssue>;
projectIssues.each() {
    projectIssue ->
        textDataField.updateValue(
            null,
            projectIssue,
            new ModifiedValue(projectIssue.getCustomFieldValue(textDataField),"new text"),
            new DefaultIssueChangeHolder()
        );
        
        // Dodanie zgłoszenia do listy w celu późniejszej reindeksacji.
        ToReindex.add(projectIssue.getKey());
}

// 6. Reindeksacja zmodyfikowanych zgłoszeń.
ToReindex.each() {
    issueKey ->
    
        // Pobranie zgłoszenia do reindeksacji.
        issueToReindex = issueManager.getIssueByCurrentKey(issueKey);

        // Pobranie stanu włączenia lub wyłączenia indeksacji.
        isIndexIssuesCurrentSettings = ImportUtils.isIndexIssues();

        // Bezwzględne włączenie indeksacji.
        ImportUtils.setIndexIssues(true);

        // Reindeksacja zgłoszenia.
        issueIndexingService.reIndex(issueToReindex);

        // Przywrócenie pierwotnego ustawienia reindeksacji.
        ImportUtils.setIndexIssues(isIndexIssuesCurrentSettings);
};