// LISTING 12.7. Aktywacja i dezaktywacja opcji select list (single choice)

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.context.IssueContextImpl;

// 1. Pobranie menedżerów.
def customFieldManager = ComponentAccessor.getCustomFieldManager();
def optionManager = ComponentAccessor.getOptionsManager();

// 2. Lista opcji custom fieldu do dezaktywacji według nazwy lub identyfikatora.

// W tym miejscu można pobrać zawartość listy opcji ze źródła zewnętrznego, np. API.
def optionsToEnableDisableByName = ["S12 Procedura przeniesienia do innego działu", "S13 Zwolnienia grupowe", "S14 Wniosek o podwyżkę", "S15 Zmiana harmonogramu czasu pracy"];

// Uwaga! Identyfikatory powinny być zawsze zweryfikowane, ponieważ wcześniejsze usunięcie i ponowne dodanie opcji o tej samej nazwie skutkuje przypisaniem innego identyfikatora.
def optionsToEnableDisableById = [10120L, 10117L, 10118L, 10119L];

// 3. Pobranie obiektu implementującego CustomField.
def caseCategoryField = customFieldManager.getCustomFieldObject(10200L);

// 4. Utworzenie kontekstu zgłoszenia, gdzie 10002 to identyfikator projektu, a 10001 to identyfikator issue type Story.
def issueContext = new IssueContextImpl(10002, "10001");

// 5. Wyszukanie i pobranie konfiguracji custom fieldu dla kontekstu OZP (id == 10301).
def caseCategoryFieldConfig = caseCategoryField.getConfigurationSchemes().find(){ configurationSchema -> configurationSchema.getId() == 10301}.getOneAndOnlyConfig();

// 6. Pobranie wszystkich dostępnych opcji custom fieldu w kontekście OZP.
def caseCateogryFieldOptions = optionManager.getOptions(caseCategoryFieldConfig);

// 7. (Opcja 1) Wyszukanie wszystkich opcji do dezaktywacji po nazwie i dezaktywacja w pętli.
caseCateogryFieldOptions.findAll() {
    option ->
        optionsToEnableDisableByName.contains(option.getValue())}.each {
            optionToEnableDisable ->
                // Opcja do odkomentowania.
                // optionManager.disableOption(optionToEnableDisable);
}

// 8. (Opcja 2) Wyszukanie wszystkich opcji do aktywacji po nazwie i aktywacja w pętli.
caseCateogryFieldOptions.findAll() {
    option ->
        optionsToEnableDisableByName.contains(option.getValue())}.each {
            optionToEnableDisable ->
                // Opcja do odkomentowania.
                // optionManager.enableOption(optionToEnableDisable);
}

// 9. (Opcja 3) Wyszukanie wszystkich opcji do dezaktywacji po identyfikatorze i dezaktywacja w pętli.
caseCateogryFieldOptions.findAll() {
    option ->
        optionsToEnableDisableById.contains(option.getOptionId())}.each {
            optionToEnableDisable ->
                // Opcja do odkomentowania.
                // optionManager.disableOption(optionToEnableDisable);
}

// 10. (Opcja 4) Wyszukanie wszystkich opcji do aktywacji po identyfikatorze i aktywacja w pętli.
caseCateogryFieldOptions.findAll() {
    option ->
        optionsToEnableDisableById.contains(option.getOptionId())}.each {
            optionToEnableDisable ->
                // Opcja do odkomentowania.
                // optionManager.enableOption(optionToEnableDisable);
}