// LISTING 12.6. Dodawanie nowych opcji do custom fieldu typu select list (single choice)

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.context.IssueContextImpl;

// 1. Pobranie menedżerów.
def customFieldManager = ComponentAccessor.getCustomFieldManager();
def optionManager = ComponentAccessor.getOptionsManager();

// 2. Lista opcji custom fieldu do dodania.
// W tym miejscu można pobrać zawartość listy opcji ze źródła zewnętrznego, np. API.
def optionsToAdd = ["S12 Procedura przeniesienia do innego działu", "S13 Zwolnienia grupowe", "S14 Wniosek o podwyżkę", "S15 Zmiana harmonogramu czasu pracy"];

// 3. Pobranie obiektu implementującego CustomField.
def caseCategoryField = customFieldManager.getCustomFieldObject(10200L);

// 4. Utworzenie kontekstu zgłoszenia, gdzie 10002 to identyfikator projektu, a 10001 to identyfikator issue type Story.
def issueContext = new IssueContextImpl(10002, "10001");

// 5. Wyszukanie i pobranie konfiguracji custom fieldu dla kontekstu OZP (id == 10301).
def caseCategoryFieldConfig =
caseCategoryField.getConfigurationSchemes().find() {
    configurationSchema ->
        configurationSchema.getId() == 10301
}.getOneAndOnlyConfig();

// 6. Pobranie wszystkich dostępnych opcji custom fieldu w kontekście OZP.
def caseCateogryFieldOptions = optionManager.getOptions(caseCategoryFieldConfig);

// 7. Dodanie nowych opcji do kontekstu OZP z wykluczeniem duplikatów.
optionsToAdd.each {
    optionToAdd ->
        if (!caseCateogryFieldOptions.any() {option -> option.getValue().equals(optionToAdd)})
            // Dodanie nowych opcji na końcu listy (wariant 1).
            optionManager.createOption(
                caseCategoryFieldConfig,
                null,
                ++caseCateogryFieldOptions.size().longValue(),
                optionToAdd
            );
            
            // Dodanie nowych opcji na początku listy (wariant 2).
            // optionManager.createOption(caseCategoryFieldConfig, null, --0.longValue(), optionToAdd);
};