// LISTING 12.2. Pobranie custom fieldu za pomocą identyfikatora lub nazwy

import com.atlassian.jira.component.ComponentAccessor;

// 1. Pobranie menedżerów.
def issueManager = ComponentAccessor.getIssueManager();
def customFieldManager = ComponentAccessor.getCustomFieldManager();

// 2. Pobranie przykładowego zgłoszenia według klucza.
def issue = issueManager.getIssueObject("TEST-1");

// 3. Pobranie obiektów implementujących CustomField przez identyfikator.
def environmentField = customFieldManager.getCustomFieldObject(10117L);
def environmentDescField = customFieldManager.getCustomFieldObject("customfield_10118");
def amountField = customFieldManager.getCustomFieldObject(10116L);

// 4. Pobieranie obiektu implementującego CustomField przez nazwę.
def notesField = customFieldManager.getCustomFieldObjectsByName("Notes").getAt(0);

// 5. Pobranie wartości custom fieldu ze zgłoszenia.
// Pole Notes będzie miało wartość null, ponieważ może być uzupełnione tylko programistycznie.
def environmentFieldValue = issue.getCustomFieldValue(environmentField);
def amountFieldValue = issue.getCustomFieldValue(amountField);
def notesFieldValue = issue.getCustomFieldValue(notesField);

// 6. Pobranie wartości custom fieldu z obiektu implementującego CustomField.
def environmentDescFieldValue = environmentDescField.getValue(issue);

// 7. Wyświetlenie wyników.
// Environment: Windows 11 | Environment desc: Build 22557 | Amount: 130.0 | Notes: null
return "Environment: ${environmentFieldValue} | Environment desc: ${environmentDescFieldValue} | Amount: ${amountFieldValue} | Notes: ${notesFieldValue}";