// LISTING 12.13. Badanie daty w custom fieldzie

import java.sql.Timestamp;
import com.atlassian.jira.component.ComponentAccessor;
import java.text.SimpleDateFormat;
import java.time.temporal.WeekFields;
import java.time.DayOfWeek;
import java.time.temporal.IsoFields;

// 1. Pobranie menedżerów.
def issueManager = ComponentAccessor.getIssueManager();
def customFieldManager = ComponentAccessor.getCustomFieldManager();

// 2. Pobranie przykładowego zgłoszenia według klucza.
def issue = issueManager.getIssueObject("OZP-1");

// 3. Pobranie obiektów implementujących CustomField.

// Date time picker.
def actionDateField = customFieldManager.getCustomFieldObject(10403L);

// Date picker.
// Wartość opcjonalna do podstawiania, tak jak date time picker.
def plannedResolutionDate = customFieldManager.getCustomFieldObject(10402L);

// 4. Pobranie wartości pól ze zgłoszenia.
def actionDateFieldValue = issue.getCustomFieldValue(actionDateField) as Timestamp;
def actionDateFieldValueTime = (issue.getCustomFieldValue(actionDateField) as Timestamp).getTime();
def plannedResolutionDateValue = issue.getCustomFieldValue(plannedResolutionDate) as Timestamp;

// 5. Pobranie bieżącej daty/czasu jako obiektu Timestamp.
def dateTimeNow = (new Date()).toTimestamp();
def dateNow = (new Date()).toTimestamp().clearTime();

// 6. Ustawienie dowolnej daty jako obiektu Timestamp.
SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
def myDateTime = formatter.parse("2022-07-11 11:45:12").toTimestamp();

// 7. Porównanie obiektu actionDateFieldValue z bieżącą datą/czasem.

// Porównanie dat/czasów w milisekundach.
def result1 = actionDateFieldValue.getTime()<dateTimeNow.getTime();

// Timestamp.compareTo() zwraca:
// -1 — data/czas mniejsza niż bieżąca, 0 — data/czas równa bieżącej, 1 — data/czas większa niż bieżąca.
def result2 = actionDateFieldValue.compareTo(dateTimeNow);

// 8. Porównanie actionDateFieldValue jako obiektu LocalDateTime z bieżącą datą/czasem.
def result3 = actionDateFieldValue.toLocalDateTime().isBefore(dateTimeNow.toLocalDateTime());
def result4 = actionDateFieldValue.toLocalDateTime().isAfter(dateTimeNow.toLocalDateTime());
def result5 = actionDateFieldValue.toLocalDateTime().isEqual(dateTimeNow.toLocalDateTime());

// 9. Sprawdzenie, czy data w actionDateFieldValue jest dzisiejsza.
def result6 = (new Timestamp(actionDateFieldValueTime)).clearTime().getTime()==dateNow.getTime();
def result7 = (new Timestamp(actionDateFieldValueTime)).toLocalDate().isEqual(dateNow.toLocalDate());

// 10. Sprawdzenie, czy data w actionDateFieldValue wystąpiła wcześniej niż pięć dni temu.

// Jeden dzień w milisekundach == 86400000.
def result8 = (new Timestamp(actionDateFieldValueTime)).clearTime().getTime() < (dateNow.clearTime().getTime() - 5 * 86400000);

// Weryfikacja za pomocą komparatora.
// Metoda compareTo() zwraca wynik 0, 1 lub -1 jak w punkcie 7.
def result9 = (new Timestamp(actionDateFieldValueTime)).clearTime().compareTo(dateNow.minus(5));

// 11. Sprawdzenie, czy data w actionDateFieldValue przypada w środę.

// Uwaga! Należy zweryfikować domyślny pierwszy dzień tygodnia.
// Niedziela może być zerowym lub siódmym dniem tygodnia w zależności od ustawień serwera i/lub Locale w aplikacji.
def result10 = actionDateFieldValue.toDayOfWeek().getValue()==3;

// Ustawienie poniedziałku jako pierwszego dnia tygodnia.
WeekFields weekFields1 = WeekFields.of(DayOfWeek.MONDAY, 1);
def result11 = actionDateFieldValue.toLocalDateTime().get(weekFields1.dayOfWeek())==3;

// 12. Sprawdzenie, w którym tygodniu miesiąca przypada data w actionDateFieldValue.
def result12 = actionDateFieldValue.toLocalDateTime().get(weekFields1.weekOfMonth());

// 13. Sprawdzenie, w którym kwartale przypada data w actionDateFieldValue.
def result13 = actionDateFieldValue.toLocalDateTime().get(IsoFields.QUARTER_OF_YEAR);

// 14. Wyświetlenie wyników.
// actionDateFieldValue: 2022-06-15 00:00:00.0 | dateTimeNow: 2022-06-18 00:00:00.0 |
// dateNow: 2022-06-18 00:00:00.0 | myDateTime: 2022-07-11 11:45:12.0 | result1: true |
// result2: -1 | result3: true | result4: false | result5: false | result6: false | result7: false |
// result8: false | result9: 1 | result10: true | result11: true | result12: 3 | result13: 2
return "actionDateFieldValue: ${actionDateFieldValue} | dateTimeNow: ${dateTimeNow} | dateNow: ${dateNow} | myDateTime: ${myDateTime} | result1: ${result1} | result2: ${result2} | result3: ${result3} | result4: ${result4} | result5: ${result5} | result6: ${result6} | result7: ${result7} | result8: ${result8} | result9: ${result9} | result10: ${result10} | result11: ${result11} | result12: ${result12} | result13: ${result13}";