// LISTING 10.9. Klasa MyPostfunctionFactory z metodami do przetwarzania parametrów post funkcji

package pl.helion.jira.workflow;

import com.atlassian.jira.plugin.webresource.JiraWebResourceManager;
import com.atlassian.jira.plugin.workflow.AbstractWorkflowPluginFactory;
import com.atlassian.jira.plugin.workflow.WorkflowPluginFunctionFactory;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.opensymphony.workflow.loader.*;
import javax.inject.Inject;
import java.util.HashMap;
import java.util.Map;

/**
 * Klasa fabryki parametrów dla szablonów Velocity i metody execute() w klasie MyPostfunction.
 */
public class MyPostfunctionFactory extends AbstractWorkflowPluginFactory implements WorkflowPluginFunctionFactory {

    // 1. Deklaracja menedżera do zarządzania statycznymi elementami strony (resources).
    private JiraWebResourceManager jiraWebResourceManager;

    /**
     * 2. Konstruktor, który wstrzyknie obiekt typu interfejsowego JiraWebResourceManager.
     * @param jiraWebResourceManager
     */
    @Inject
    public MyPostfunctionFactory(@ComponentImport JiraWebResourceManager jiraWebResourceManager) {
        this.jiraWebResourceManager = jiraWebResourceManager;
    }

    @Override
    protected void getVelocityParamsForInput(Map<String, Object> velocityParams) {

        // 3. Przekazanie do modelu obiektu menedżera w celu załadowania źródeł w szablonie Velocity.
        velocityParams.put("jiraWebResourceManager", jiraWebResourceManager);
    }

    /**
     * 4. Metoda zwraca aktualnie zapisane dane formularza ustawień post funkcji.
     * @param velocityParams
     * @param descriptor
     */
    @Override
    protected void getVelocityParamsForEdit(Map<String, Object> velocityParams, AbstractDescriptor descriptor) {
        getVelocityParamsForInput(velocityParams);
        getVelocityParamsForView(velocityParams, descriptor);
    }

    /**
     * 5. Metoda zwraca aktualnie zapisane dane ustawień post funkcji do wyświetlenia
     * w liście włączonych post funkcji.
     * @param velocityParams
     * @param descriptor
     */
    @Override
    protected void getVelocityParamsForView(Map<String, Object> velocityParams, AbstractDescriptor descriptor) {
        if (!(descriptor instanceof FunctionDescriptor))
            throw new IllegalArgumentException("Descriptor must be a FunctionDescriptor.");
        
        FunctionDescriptor functionDescriptor = (FunctionDescriptor) descriptor;
        String subtaskSummary = (String) functionDescriptor.getArgs().get("subtaskSummary");

        // 6. Przekazanie do modelu zmiennej subtaskSummary, zawierającej daną z ustawień post funkcji.
        velocityParams.put("subtaskSummary", subtaskSummary);
    }

    /**
     * 7. Metoda zwraca parametry post funkcji z deskryptora.
     * @param formParams
     * @return
     */
    public Map<String, ?> getDescriptorParams(Map<String, Object> formParams) {
        Map params = new HashMap();
        String subtaskSummary = extractSingleParam(formParams, "subtaskSummary");
        params.put("subtaskSummary", subtaskSummary);
        return params;
    }
}