// LISTING 10.14. Klasa MyCondition z metodą realizującą warunek przejścia

package pl.helion.jira.workflow;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.workflow.condition.AbstractJiraCondition;
import com.opensymphony.module.propertyset.PropertySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.Map;

/*** Klasa zawiera metodę passesCondition(), w której ciele umieszcza się kod zwracający
 * true albo false.
 * Wynik stanowi podstawę działania warunku przejścia.
 * W mapie args znajdują się zmienne załadowane w metodzie getDescriptorParams()
 * z klasy MyConditionFactory.
 */
public class MyCondition extends AbstractJiraCondition {
   
    // 1. Pobranie loggera.
    private static final Logger log = LoggerFactory.getLogger(MyCondition.class);
   
    /**
     * 2. Metoda wykonująca skrypt warunku przed wykonaniem przejścia.
     * @param transientVars — tablica przechowująca dane przejścia.
     * @param args — parametry załadowane w MyConditionFactory.
     * @param ps — property nie jest wykorzystywane.
     * @return result — true (przejście zostanie wyświetlone) albo false (przejście zostanie ukryte).
     */
    public boolean passesCondition(Map transientVars, Map args, PropertySet ps) {

        // 3. Pobranie wartości Assignee starts with z ustawień warunku przejścia.
        String assigneeUserName = (String) args.get("assigneeUserName");

        // 4. Pobranie obiektu typu interfejsowego Issue z danych przejścia.
        Issue issue = getIssue(transientVars);

        // 5. Pobranie obiektu typu interfejsowego ApplicationUser osoby aktualnie przypisanej do zgłoszenia.
        ApplicationUser assignee = issue.getAssignee();

        // 6. Sprawdzenie warunków.
        boolean result = true;
        if (assignee==null) result = false;
        else if (assignee.getName().startsWith(assigneeUserName)) result = true;
        else result = false;

        // 7. Zwrócenie wyniku.
        return result;
    }
}