using System.IO;

// Wygenerowanie 4096-bitowego klucza RSA z haszem SHA512
var ca = CertificateUtils.GenerateCACert("CN=MyTestCA",
           4096, CertificateHashAlgorithm.Sha512);

// Eksport do liku PFX bezhasa
File.WriteAllBytes("ca.pfx", ca.ExportToPFX());

// Eksport publicznego certyfikatu do pliku PEM
File.WriteAllText("ca.crt", ca.ExportToPEM());
