﻿<%@ Page Language="C#" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
  <title>ASP.NET AJAX</title>

  <script language="JavaScript" type="text/javascript">
    function loadVendors() {
      Vendors.GetVendors(callComplete, callError);
    }

    function callComplete(result) {
      $get("output").control.set_data(result);
    }
    function callError(result) {
      $get("output").innerHTML = "Błąd: " + result.get_message();
    }
  </script>

</head>
<body>
  <form id="form1" runat="server">
    <asp:ScriptManager runat="server">
      <Services>
        <asp:ServiceReference Path="ListViewVendors.asmx" />
      </Services>
      <Scripts>
        <asp:ScriptReference Name="PreviewScript.js" Assembly="Microsoft.Web.Preview" />
      </Scripts>
    </asp:ScriptManager>
    <input type="button" value="Pobierz dane firm" onclick="loadVendors();" />
    <div id="output">
      Tutaj zostanie wyświetlona lista firm</div>
    <div style="display: none;">
      <div id="vendorsLayout">
        <table>
          <thead>
            <tr><th>Konto</th><th>Nazwa</th></tr>
          </thead>
          <tbody id="vendorsItemParent">
            <tr id="vendorsItem">
              <td id="vendorsAccountNumber">Tutaj zostaną wyświetlone numery kont</td>
              <td id="vendorsName">Tutaj zostaną wyświetlone nazwy firm</td>
            </tr>
          </tbody>
        </table>
      </div>
    </div>
  </form>

  <script type="text/xml-script">
    <page xmlns="http://schemas.microsoft.com/xml-script/2005">
      <components>
        <listView itemTemplateParentElementId="vendorsItemParent" id="output">
          <layoutTemplate>
            <template layoutElement="vendorsLayout" />
          </layoutTemplate>
          <itemTemplate>
            <template layoutElement="vendorsItem">
              <label id="vendorsAccountNumber">
                <bindings>
                  <binding dataPath="AccountNumber" property="text" />
                </bindings>
              </label>
              <label id="vendorsName">
                <bindings>
                  <binding dataPath="Name" property="text" />
                </bindings>
              </label>
            </template>
          </itemTemplate>
        </listView>
      </components>
    </page>
  </script>

</body>
</html>
