<%@ WebService Language="C#" Class="Vendors" %>

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using System.Data;
using System.Data.SqlClient;
using System.Text.RegularExpressions;

[WebService(Namespace = "http://hauser-wenz.de/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
[System.Web.Script.Services.ScriptService]
public class Vendors : System.Web.Services.WebService
{

  [WebMethod]
  public string[] GetVendors(string prefixText, int count)
  {
    Regex regex = new Regex("^[a-zA-Z ]*$");
    if (!regex.IsMatch(prefixText) || count < 1 || count > 100)
    {
      return null;
    }
    SqlConnection conn = new SqlConnection(
      "server=(local)\\SQLEXPRESS; Integrated Security=true; Initial Catalog=AdventureWorks");
    conn.Open();
    SqlCommand comm = new SqlCommand(
      "SELECT TOP " +
        count +
        " Name FROM Purchasing.Vendor WHERE Name LIKE '" +
        prefixText +
        "%'",
      conn);
    SqlDataAdapter adap = new SqlDataAdapter(comm);
    DataSet ds = new DataSet();
    adap.Fill(ds);

    string[] vendors = new string[Math.Min(count, ds.Tables[0].Rows.Count)];
    for (int i = 0; i < Math.Min(count, ds.Tables[0].Rows.Count); i++)
    {
      vendors[i] = ds.Tables[0].Rows[i].ItemArray[0].ToString();
    }
    return vendors;
  }

}
