﻿<%@ Page Language="C#" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head id="Head1" runat="server">
    <title>Microsoft ASP.NET Futures: Sys.Control Bindings Using JavaScript</title>
    <link href="~/include/qsstyle.css" type="text/css" rel="Stylesheet" />
    
    <script type="text/javascript">
    function pageLoad() 
    {
        // EXAMPLE #1:
        // Create the controls
        var textBox = new Sys.Preview.UI.TextBox($get('textBox'));
        var checkBoxBoolean = new Sys.Preview.UI.CheckBox($get('checkBoxBoolean'));
        var checkBoxDisabled = new Sys.Preview.UI.CheckBox($get('checkBoxDisabled'));
        
        // Create the binding on the textbox
        var binding_1 = new Sys.Preview.Binding();
        binding_1.set_dataContext(checkBoxBoolean);
        binding_1.set_dataPath('checked');
        binding_1.set_property('text');
        binding_1.set_transformerArgument("Checkbox is {0}.");
        binding_1.set_direction(Sys.Preview.BindingDirection.In);
        
        // This is the built-in transform ToString
        binding_1.add_transform(Sys.Preview.BindingBase.Transformers.ToString);

        // Create the binding on the checkbox
        var binding_2 = new Sys.Preview.Binding();
        binding_2.set_dataContext(checkBoxBoolean);
        binding_2.set_dataPath('checked');
        binding_2.set_property('checked');
        
        // This is the built-in transform Invert
        binding_2.add_transform(Sys.Preview.BindingBase.Transformers.Invert);
        
        // Add the bindings to the controls
        binding_1.set_target(textBox);
        binding_2.set_target(checkBoxDisabled);
        
        // Initialize the controls
        textBox.initialize();
        checkBoxDisabled.initialize();
        checkBoxBoolean.initialize();        
                
        // EXAMPLE #2:
        // Create the controls
        var textBoxNumber = new Sys.Preview.UI.TextBox($get('textBoxNumber'));
        var spanLabel = new Sys.Preview.UI.Label($get('spanLabel'));
        textBoxNumber.set_text("0");
        
        // Create the binding
        var binding_3 = new Sys.Preview.Binding();
        binding_3.set_dataContext(textBoxNumber);
        binding_3.set_dataPath('text');
        binding_3.set_property('text');
        binding_3.set_transformerArgument(5);
        binding_3.add_transform(Sys.Preview.BindingBase.Transformers.Add);
        
        // Add the binding
        binding_3.set_target(spanLabel);

        // Initialize the controls
        textBoxNumber.initialize();
        spanLabel.initialize(); 
        
        // EXAMPLE #3:
        // 
        var textBoxString = new Sys.Preview.UI.TextBox($get('textBoxString'));
        var spanLabel2 = new Sys.Preview.UI.Label($get('spanLabel2'));
        textBoxString.set_text("Hello");
        
        // Create the binding
        var binding_4 = new Sys.Preview.Binding();
        binding_4.set_dataContext(textBoxString);
        binding_4.set_dataPath('text');
        binding_4.set_property('text');
        binding_4.add_transform(customTransform);
        
        // Add the binding
        binding_4.set_target(spanLabel2);

        // Initialize the controls
        textBoxString.initialize();
        spanLabel2.initialize(); 
        
        // Initialize the bindings
        binding_1.initialize();
        binding_2.initialize();
        binding_3.initialize();
        binding_4.initialize();
    }
    
    function customTransform(sender, eventArgs)
    {
        var value = eventArgs.get_value();
            
        var reverseStr = new Sys.StringBuilder();
        for (var i=value.length-1; i>=0; i--)
            reverseStr.append(value.charAt(i));
            
        eventArgs.set_value(reverseStr.toString());    
    }
    </script>
</head>

<body>
    <form id="form1" runat="server">
        <div>
            <asp:ScriptManager runat="server" ID="ScriptManager1">
                <Scripts>
                    <asp:ScriptReference Name="PreviewScript.js" Assembly="Microsoft.Web.Preview" />
                </Scripts>
            </asp:ScriptManager>
            <h2>
                Microsoft ASP.NET Futures: Bindings in JavaScript</h2>
            <p>
            </p>
            <div id="Div1" class="new">
                This demonstration shows in the programmatic form, the ability to:
                <ol>
                    <li>Bind the data from a control to another control;</li>
                    <li>Utilize the bindings 'transformers' to manipulate data;</li>
                    <li>Setting properties, (enabled, visible, text)</li>
                    <li>Invoke your own custom transform</li>
                </ol>
            </div>
            <p>
            </p>
            <h2>
                Example 1:</h2>
            Click the checkbox to 'transform' the checked property to a string and assign the
            value to the textbox.
            <br />
            The disabled check box will also show the inverse 'transform' on the checked property.
            <br />
            Since the binding is "inOut" you can also type true|false in the textbox to affect
            the controls in the reverse order.
            <br />
            <br />
            Bool Value (true|false):
            <input type="checkbox" id="checkBoxBoolean" checked="checked" />
            &nbsp; Bool Value (true|false):
            <input type="checkbox" id="checkBoxDisabled" disabled="disabled" />
            &nbsp;<input type="text" id="textBox" size="15" class="sampleresult" />
            <hr />
            <h2>
                Example 2:</h2>
            This example binds the label (a span element), to the text box and demonstrates
            the in-built transform to add the value 5 (a transform argument) to the entered
            value. <b>Note</b>: you will need to enter a valid number as this sample performs
            no validation checking, and click away from the textbox.
            <p>
            </p>
            Enter a number:&nbsp;
            <input type="text" id="textBoxNumber" size="5" class="sampleinput" />
            &nbsp; Incremented Number: <span id="spanLabel" class="sampleresult"></span>
            <hr />
            <h2>
                Example 3:</h2>
            This example binds the label (a span element), to the text box and demonstrates
            a custom transform to reverse the text from the entered value.
            <p>
            </p>
            Enter a string:&nbsp;
            <input type="text" id="textBoxString" size="15" class="sampleinput" />
            &nbsp; Reversed Text: <span id="spanLabel2" class="sampleresult"></span>
        </div>
    </form>
</body>
</html>
    
   
