﻿<%@ Page Language="C#" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head id="Head1" runat="server">
    <style type="text/css">
        .redLocal{background-color:red;color:white;font-size:24pt;}
        .greenLocal{background-color:green;color:white;font-size:24pt;}
        .blueLocal{background-color:blue;color:white;font-size:24pt;}
    </style>
    <title>Microsoft ASP.NET Futures: Component Bindings: Using Xml-Script</title>
    <link href="~/include/qsstyle.css" type="text/css" rel="Stylesheet" />
</head>

<body>
    <form id="form1" runat="server">
        <div>
            <asp:ScriptManager runat="server" ID="ScriptManager1">
                <Scripts>
                    <asp:ScriptReference Name="PreviewScript.js" Assembly="Microsoft.Web.Preview" />
                </Scripts>
            </asp:ScriptManager>
            <h2>
                Microsoft ASP.NET Futures: Bindings using Xml-Script</h2>
            <p />
            <div id="Div1" class="new">
                This demonstration shows, in the declarative form, the ability to:
                <ol>
                    <li>Bind the data from a control to another control;</li>
                    <li>Utilize the bindings 'transformers' to manipulate data;</li>
                    <li>Invoke bindings from property changed events</li>
                </ol>
            </div>
            <p />
            <h2>
                Example 1:</h2>
            Click the checkbox to 'transform' the checked property to a string and assign the
            value to the textbox. (The textBox binding is "In"). The disabled check box will
            also show the inverse 'transform' on the checked property.
            <br />
            <br />
            Bool Value (true|false):
            <input type="checkbox" id="checkBoxBoolean" />
            &nbsp; Bool Value (true|false):
            <input type="checkbox" id="checkBoxDisabled" disabled="disabled" />
            &nbsp;<input type="text" id="textBox" class="sampleresult" />
            <h2>
                Example 2:</h2>
            This example binds the label (a span element), to the text box and demonstrates
            the in-built transform to add the value 5 (a transform argument) to the entered
            value. <b>Note</b>: you will need to enter a valid number as this sample performs
            no validation checking, and click away from the textbox.
            <p>
            </p>
            Enter a number:&nbsp;
            <input type="text" id="textBoxNumber" size="5" class="sampleinput" />
            &nbsp; Incremented Number: <span id="label" class="sampleresult"></span>
            <h2>
                Example 3:</h2>
            This example binds a dropdown list (a select element), to a label and demonstrates
            a custom transform which inspects the value being passed to the label and sets the
            stylesheet from an array that defines the transformargument.
            <p>
            </p>
            Define Text:&nbsp;
            <input type="text" id="textBoxText" size="5" class="sampleinput" />
            &nbsp; Select a value:&nbsp;
            <select id="selectStyle" class="sampleinput">
                <option value="redLocal">Red</option>
                <option value="greenLocal">Green</option>
                <option value="blueLocal">Blue</option>
            </select>
            &nbsp; Result: <span id="labelText"></span>

            <script type="text/javascript">
                function DoAdditionalHandling(sender, eventArgs)
                {
                    var tbxElem = $get('textBoxText').control;
                    if (tbxElem.get_text().length > 0)
                    {
                        // The value is that from the select, so let's ensure it's set
                        // The property here is the cssClass
                        eventArgs.set_value(eventArgs.get_value());
                        
                        // Add additional text to the output:
                        var textElem = $get('labelText').control;
                        textElem.set_text(tbxElem.get_text() + " (You used the style selector)");
                    }
                }
            </script>

            <script type="text/xml-script">
                <page xmlns="http://schemas.microsoft.com/xml-script/2005">
                    <components>
                        <textBox id="textBox">
                            <bindings>
                                <binding dataContext="checkBoxBoolean" dataPath="checked" property="text" transform="ToString" direction="In" transformerArgument="Checkbox is {0}" />
                            </bindings>
                        </textBox>
                        <checkBox id="checkBoxBoolean" />
                        <checkBox id="checkBoxDisabled">
                            <bindings>
                                <binding dataContext="checkBoxBoolean" dataPath="checked" property="checked" transform="Invert" />
                            </bindings>
                        </checkBox>
                        <textBox id="textBoxNumber" />
                        <label id="label">
                            <bindings>
                                <binding dataContext="textBoxNumber" dataPath="text" property="text" transform="Add" transformerArgument="5" />
                            </bindings>
                        </label>
                        <textBox id="textBoxText" />
                        <selector id="selectStyle">
                            <selectionChanged>
                                <invokeMethodAction target="setCss" method="evaluateIn" />
                            </selectionChanged>
                        </selector>
                        <label id="labelText">
                            <bindings>
                                <binding dataContext="textBoxText" dataPath="text" property="text" />
                                <binding id="setCss" dataContext="selectStyle" dataPath="selectedValue" property="element" propertyKey="className" transform="DoAdditionalHandling" />
                            </bindings>
                        </label>
                    </components>
                </page>
            </script>

        </div>
    </form>
</body>
</html>
    
   
