<%@ WebService Language="C#" Class="MathService" %>

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;

public class DivisionData
{
    public float result;
    public string calculationTime;
}

[WebService(Namespace = "http://hauser-wenz.de/AspNetAJAX/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
[System.Web.Script.Services.ScriptService]
[System.Web.Script.Services.GenerateScriptType(typeof(DivisionData))]
public class MathService : System.Web.Services.WebService
{

    [WebMethod]
    public float DivideNumbers(int a, int b)
    {
        if (b == 0)
        {
            throw new DivideByZeroException();
        }
        else
        {
            return (float)a / b;
        }
    }


    [WebMethod]
    public DivisionData ExtendedDivideNumbers(int a, int b)
    {
        if (b == 0)
        {
            throw new DivideByZeroException();
        }
        else
        {
            float res = (float)a / b;
            string stamp = DateTime.Now.ToLongTimeString();
            DivisionData d = new DivisionData();
            d.result = res;
            d.calculationTime = stamp;
            return d;
        }
    }

}
