﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using System.Drawing;

namespace Reversi
{
    public partial class _Default : System.Web.UI.Page
    {
        private Color[] kolory = { Color.Ivory, Color.Green, Color.Sienna };
        private string[] nazwyGraczy = { "", "zielony", "brązowy" };

        private void uzgodnijZawartoscPlanszy(ReversiSilnik silnik)
        {
            for (int i = 0; i < ReversiSilnik.PlanszaSzer; i++)
                for (int j = 0; j < ReversiSilnik.PlanszaWys; j++)
                {
                    int stanPola = silnik.StanPola(i, j);
                    //Plansza1[i, j].Text = stanPola.ToString();
                    Plansza1.UstawKolorPola(i, j, kolory[stanPola]);
                    Plansza1.ZablokujPole(i, j, stanPola != 0);
                    //Plansza1[i, j].Text = silnik.PolozKamien(i, j, true).ToString();                    
                }

            Label1.Text = "<font color=" + kolory[1].Name + ">Gracz " + nazwyGraczy[1] + "<br>Ilość pól: " + silnik.IloscPolGracz1.ToString() + "</font>";
            Label2.Text = "<font color=" + kolory[2].Name + ">Gracz " + nazwyGraczy[2] + "<br>Ilość pól: " + silnik.IloscPolGracz2.ToString() + "</font>";
            Button1.BackColor = kolory[0];
            Button2.BackColor = kolory[0];
            Label4.Text = "<font color=" + kolory[silnik.NumerGraczaWykonujacegoNastepnyRuch].Name + ">" + nazwyGraczy[silnik.NumerGraczaWykonujacegoNastepnyRuch] + "</font>";
        }

        ReversiSilnik silnik;

        protected void Page_Load(object sender, EventArgs e)
        {
            /*
            ReversiSilnik silnik = new ReversiSilnik(1);
            silnik.PolozKamien(2, 4);
            silnik.PolozKamien(4, 5);
            */
            if (Session["silnik"] == null)
            {
                silnik = new ReversiSilnik(1);
                Session.Add("silnik", silnik);
                WyswietlKomunikat("Gra rozpoczęta.", false);
            }
            else silnik = Session["silnik"] as ReversiSilnik;

            uzgodnijZawartoscPlanszy(silnik);

            Plansza1.KliknieciePolaPlanszy += Plansza1_KliknieciePolaPlanszy;

            /*
            string s = "Plansza:<br>";
            for (int pionowo = 0; pionowo < ReversiSilnik.PlanszaWys; pionowo++)
            {
                for (int poziomo = 0; poziomo < ReversiSilnik.PlanszaSzer; poziomo++)
                {
                    s += silnik.StanPola(poziomo, pionowo) + " ";
                }
                s += "<br>";
            }

            s += "<p>Ilość pustych pól: " + silnik.IloscPolPustych +
                "<br>Ilość pól gracza 1:" + silnik.IloscPolGracz1 +
                "<br>Ilość pól gracza 2:" + silnik.IloscPolGracz2;

            Label l = new Label();
            l.Text = s;
            l.Font.Name = "Courier";
            form1.Controls.Add(l);
            */
        }

        public static string SymbolPola(int poziomo, int pionowo)
        {
            if (poziomo > 25 || pionowo > 8) return "(" + poziomo.ToString() + "," + pionowo.ToString() + ")";
            return "" + "ABCDEFGHIJKLMNOPQRSTUVWXYZ"[poziomo] + "123456789"[pionowo];
        }

        void WyswietlKomunikat(string treśćKomunikatu, bool dodaj = true)
        {
            if (!dodaj) Label3.Text = "";
            Label3.Text = DateTime.Now.ToString() + " - " + treśćKomunikatu + "<br>" + Label3.Text;
        }

        bool koniecGry = false;

        void Plansza1_KliknieciePolaPlanszy(object sender, Plansza.PolePlanszyEventArgs e)
        {
            if (koniecGry) return;

            //wykonanie ruchu
            int zapamietanyNumerGracza = silnik.NumerGraczaWykonujacegoNastepnyRuch;
            if (silnik.PolozKamien(e.poziomo, e.pionowo))
            {
                uzgodnijZawartoscPlanszy(silnik);

                //lista ruchow
                switch (zapamietanyNumerGracza)
                {
                    case 1: ListBox1.Items.Add(SymbolPola(e.poziomo, e.pionowo)); break;
                    case 2: ListBox2.Items.Add(SymbolPola(e.poziomo, e.pionowo)); break;
                }
                ListBox1.SelectedIndex = ListBox1.Items.Count - 1;
                ListBox2.SelectedIndex = ListBox2.Items.Count - 1;
                WyswietlKomunikat("<font color=" + kolory[zapamietanyNumerGracza].Name + ">Gracz " + nazwyGraczy[zapamietanyNumerGracza] + " położył kamień na polu " + SymbolPola(e.poziomo, e.pionowo) + "</font>");

                //sytuacje specjalne
                ReversiSilnik.SytuacjeNaPlanszy sytuacjaNaPlanszy = silnik.ZbadajSytuacjeNaPlanszy();
                switch (sytuacjaNaPlanszy)
                {
                    case ReversiSilnik.SytuacjeNaPlanszy.BiezacyGraczNieMozeWykonacRuchu:
                        WyswietlKomunikat("Gracz " + nazwyGraczy[silnik.NumerGraczaWykonujacegoNastepnyRuch] + " zmuszony jest do oddania ruchu");
                        silnik.Pasuj();
                        uzgodnijZawartoscPlanszy(silnik);
                        break;
                    case ReversiSilnik.SytuacjeNaPlanszy.ObajGraczeNieMogaWykonacRuchu:
                        WyswietlKomunikat("Obaj gracze nie mogą wykonać ruchu");
                        koniecGry = true;
                        break;
                    case ReversiSilnik.SytuacjeNaPlanszy.WszystkiePolaPlanszySaZajete:
                        koniecGry = true;
                        break;
                }

                //wylonienie zwyciezcy
                if (koniecGry)
                {
                    for (int i = 0; i < ReversiSilnik.PlanszaSzer; i++)
                        for (int j = 0; j < ReversiSilnik.PlanszaWys; j++)
                            Plansza1.ZablokujPole(i, j);

                    int numerZwyciezcy = (silnik.IloscPolGracz1 > silnik.IloscPolGracz2) ? 1 : 2;
                    if (silnik.IloscPolGracz1 == silnik.IloscPolGracz2) numerZwyciezcy = 0;
                    if (numerZwyciezcy != 0) WyswietlKomunikat("Wygrał gracz " + nazwyGraczy[numerZwyciezcy]);
                    else WyswietlKomunikat("Remis");

                    Button1.Font.Bold = true;
                    Button2.Enabled = false;
                    CheckBox1.Enabled = false;
                }                
            }
            else WyswietlKomunikat("Położenie kamienia na polu " + SymbolPola(e.poziomo, e.pionowo) + " przez gracza " + nazwyGraczy[silnik.NumerGraczaWykonujacegoNastepnyRuch] + " nie było możliwe");
        }

        private void przygotowaniePlanszyDoNowejGry()
        {
            ListBox1.Items.Clear();
            ListBox2.Items.Clear();

            for (int i = 0; i < ReversiSilnik.PlanszaSzer; i++)
                for (int j = 0; j < ReversiSilnik.PlanszaWys; j++)
                    Plansza1.ZablokujPole(i, j, false);

            uzgodnijZawartoscPlanszy(silnik);

            Button1.Font.Bold = false;
            Button2.Enabled = true;
            CheckBox1.Enabled = true;

            WyswietlKomunikat("Gra rozpoczęta", false);
        }

        protected void Button1_Click(object sender, EventArgs e)
        {
            silnik = new ReversiSilnik(1);
            Session["silnik"] = silnik;
            przygotowaniePlanszyDoNowejGry();            
        }
    }
}