﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

using System.Xml.Linq;

namespace Wpisy_BibliotekaUslug
{
    //Model księgi gości. Tu zapisana jest logika biznesowa aplikacji
    public class Wpisy
    {
        List<Wpis> wpisy = new List<Wpis>();

        public bool ZapiszDoPlikuPoKażdymDodaniuWpisu = true;

        public void Dodaj(Wpis nowyWpis)
        {
            wpisy.Add(nowyWpis);
            if (ZapiszDoPlikuPoKażdymDodaniuWpisu) ZapiszDoPlikuXml();
        }
        
        public int Ilość
        {
            get
            {
                return wpisy.Count;
            }
        }

        public Wpis this[int i]
        {
            get
            {
                return wpisy[i];
            }
        }        

        public bool ZapiszDoPlikuXml(string nazwaPlikuXml = null)
        {
            if (nazwaPlikuXml == null) nazwaPlikuXml = this.nazwaPlikuXml;

            try
            {
                if (System.IO.File.Exists(nazwaPlikuXml)) System.IO.File.Copy(nazwaPlikuXml, nazwaPlikuXml + ".bak", true);

                XDocument xml = new XDocument(
                    new XDeclaration("1.0", "utf-8", "yes"),
                    new XElement("Wpisy",
                        new XElement("DataZapisu", DateTime.Now.ToString()),
                        from wpis in wpisy
                        select new XElement("Wpis",
                            new XElement("NazwaUżytkownika", wpis.NazwaUżytkownika),
                            new XElement("Treść", wpis.Treść),
                            new XElement("Data", wpis.Data),
                            new XElement("AdresIP", wpis.AdresIP)
                        )
                    )
                );

                xml.Save(nazwaPlikuXml);
                //Global.DopiszDoPlikuLog("Zapis prawidłowy");
                return true;
            }
            catch//(Exception exc)
            {
                //Global.DopiszDoPlikuLog(exc.Message);
                return false;
            }
        }

        private bool CzytajZPlikuXml(string nazwaPlikuXml)
        {
            try
            {
                XDocument xml = XDocument.Load(nazwaPlikuXml);

                IEnumerable<Wpis> odczytaneWpisy =
                    from wpis in xml.Descendants("Wpis")
                    select
                       new Wpis(
                           wpis.Element("NazwaUżytkownika").Value,
                           wpis.Element("Treść").Value,
                           DateTime.Parse(wpis.Element("Data").Value),
                           wpis.Element("AdresIP").Value);

                wpisy.Clear();
                wpisy.AddRange(odczytaneWpisy);

                return true;
            }
            catch
            {
                return false;
            }
        }

        string nazwaPlikuXml;

        public Wpisy(string nazwaPlikuXml)
        {
            this.nazwaPlikuXml = nazwaPlikuXml;
            CzytajZPlikuXml(nazwaPlikuXml);
        }

        public Wpis[] DoTablicy()
        {
            return wpisy.ToArray();
        }
    }
}