﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using System.Threading.Tasks;

namespace ParallelDemo
{
    public partial class Default : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {

        }

        private double obliczenia(double argument)
        {
            for (int i = 0; i < 10; ++i)
            {
                argument=Math.Asin(Math.Sin(argument));
            }
            return argument;
        }

        protected void Button1_Click(object sender, EventArgs e)
        {
            //przygotowania            
            int rozmiar = 10000;
            Random r = new Random();
            double[] tablica = new double[rozmiar];
            for (int i = 0; i < tablica.Length; ++i) tablica[i] = r.NextDouble();

            //obliczenia sekwencyjne
            int iloscPowtorzen = 100;
            double[] wyniki = new double[tablica.Length];
            int start = System.Environment.TickCount;
            for (int powtorzenia = 0; powtorzenia < iloscPowtorzen; ++powtorzenia)
                for (int i = 0; i < tablica.Length; ++i) 
                    wyniki[i] = obliczenia(tablica[i]);
            int stop = System.Environment.TickCount;
            Label1.Text = "Obliczenia sekwencyjne trwały " + (stop - start).ToString() + " ms.<BR>";

            //obliczenia równoległe
            start = System.Environment.TickCount;
            for (int powtorzenia = 0; powtorzenia < iloscPowtorzen; ++powtorzenia)
            {
                Parallel.For(0, tablica.Length,(int i) => wyniki[i] = obliczenia(tablica[i]));
            }
            stop = System.Environment.TickCount;
            Label1.Text += "Obliczenia równoległe trwały " + (stop - start).ToString() + " ms.<P>";

            //prezentacja wyników                        
            /*
            string s = "<B>Wyniki:</B><BR>";
            for (long i = 0; i < tablica.Length; ++i) s += i + ". " + tablica[i] + " ?= " + wyniki[i] + "<BR>";
            Label1.Text += s;
            */
        }

        protected void Button2_Click(object sender, EventArgs e)
        {
            Random r = new Random();
            long suma = 0;
            long licznik = 0;
            string s = "";

            //iteracje zostana wykonane tylko dla liczb parzystych
            //petla zostanie przerwana wcześniej, jeżeli wylosowana liczba jest większa od 90
            Parallel.For(0, 10000, (int i, ParallelLoopState stanPetli) =>
                {
                    int liczba = r.Next(7); //losowanie liczby oczek na kostce                    
                    if (liczba == 0)
                    {
                        s += "Stop:";
                        stanPetli.Stop();
                        //stanPetli.Break();
                    }
                    if (stanPetli.IsStopped) return;
                    if (liczba % 2 == 0)
                    {
                        s += "<FONT COLOR=green>" + liczba.ToString() + "</FONT>; ";
                        obliczenia(liczba);
                        suma += liczba;
                        licznik++;
                    }
                    else s += "<FONT COLOR=red>" + liczba.ToString() + "</FONT>; ";
                });

            Label1.Text = 
                "Wylosowane liczby: " + s + 
                "<BR>Liczba pasujących liczb: " + licznik + 
                "<BR>Suma: " + suma + 
                "<BR>Średnia: " + (suma / (double)licznik).ToString();
        }
    }
}