﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace KsiegaGosci
{
    //Model księgi gości. Tu zapisana jest logika biznesowa aplikacji
    public class Wpisy
    {
        public bool ZapiszDoPlikuPoKażdymDodaniuWpisu = true;

        public void Dodaj(Wpis nowyWpis)
        {
            int noweID = 0;
            if (sql.Wpis.Count() > 0) noweID = sql.Wpis.Max(wpis => wpis.ID) + 1;
            nowyWpis.ID = noweID;

            sql.Wpis.InsertOnSubmit(nowyWpis);
            if (ZapiszDoPlikuPoKażdymDodaniuWpisu) ZapiszDoBazyDanych();
        }
        
        public int Ilość
        {
            get
            {
                return sql.Wpis.Count();
            }
        }

        public Wpis this[int i]
        {
            get
            {
                return sql.Wpis.First(wpis => wpis.ID == i);
            }
        }

        #region Obsługa bazy danych SQL Server
        KsiegaGosciDataContext sql = new KsiegaGosciDataContext();

        private void ZapiszDoBazyDanych()
        {            
            sql.SubmitChanges();
        }
        #endregion
    }
}