﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace KsiegaGosci
{
    public partial class Default : System.Web.UI.Page
    {
        //const string nazwaZmiennej_Wpisy = "wpisy";
        //const string nazwaZmiennej_Parzysty = "parzysty";

        protected void Page_Load(object sender, EventArgs e)
        {
            //if (Application[nazwaZmiennej_Wpisy] == null) Application.Add(nazwaZmiennej_Wpisy, new List<string>());
            //else WyświetlanieWpisów();
            //if (Application[nazwaZmiennej_Parzysty] == null) Application.Add(nazwaZmiennej_Parzysty, true);

            WyświetlanieWpisów();
        }

        protected void Page_Init(object sender, EventArgs e)
        {
            if (TextBox1.Text == "")
            {
                string nazwaUżytkownika = PrzypomnijNazwęUżytkownika();
                if (nazwaUżytkownika != null) TextBox1.Text = nazwaUżytkownika;
            }
        }

        /*
        private void WyświetlanieWpisów()
        {
            List<string> wpisy = (List<string>)Application[nazwaZmiennej_Wpisy];

            string trescWpisow = "";
            foreach (string wpis in wpisy) trescWpisow += wpis;
            Label1.Text = trescWpisow;
        }
        */

        private void WyświetlanieWpisów(bool odwróćKolejność = true)
        {
            List<string> wpisy = (List<string>)Application[Global.nazwaZmiennej_Wpisy];
            
            string trescWpisow = "";
            if (!odwróćKolejność) foreach (string wpis in wpisy) trescWpisow += wpis;
            else for (int i = wpisy.Count - 1; i >= 0; --i) trescWpisow += wpisy[i];
            Label1.Text = trescWpisow;
        }

        const string kolorParzysty = "navy";
        const string kolorNieparzysty = "blue";

        private static string KolorNagłówka(int numerWpisu)
        {
            return (numerWpisu % 2 == 0) ? kolorParzysty : kolorNieparzysty;
        }

        protected void Button1_Click(object sender, EventArgs e)
        {
            if (TextBox1.Text == "" || TextBox2.Text == "") return; //walidacja po stronie serwera

            //ustalanie treści wpisu
            List<string> wpisy = (List<string>)Application[Global.nazwaZmiennej_Wpisy];
            string nagłówek = "<FONT COLOR='" + KolorNagłówka(wpisy.Count) + "'><B> Dodano dnia " + DateTime.Now.ToString() + "</B></FONT>";
            string treść = TextBox2.Text.Trim().Replace("\n", "<BR>");
            string podpis = "<I>" + TextBox1.Text.Trim() + "</I> (" + this.Request.UserHostAddress + ")";

            //dodawanie wpisu
            string nowyWpis = nagłówek + "<BR>" + treść + "<BR>" + podpis + "<P>";
            nowyWpis += "<HR WIDTH='30%' ALIGN='left'>";
            wpisy.Add(nowyWpis);

            //wyświetlanie wpisów
            WyświetlanieWpisów();

            TextBox2.Text = ""; //czyszczenie pola edycyjnego z treścią wpisu

            //zapis do pliku
            //Global.ZapiszDoPlikuTxt(wpisy);
            Global.DopiszDoPlikuTxt(nowyWpis);
            ZapamietajNazwęUżytkownika(TextBox1.Text);
        }

        void ZapamietajNazwęUżytkownika(string nazwaUżytkownika)
        {
            HttpCookie ciasteczko = new HttpCookie("imie", nazwaUżytkownika);
            ciasteczko.Expires = DateTime.Today.AddDays(3);
            Response.Cookies.Add(ciasteczko);
        }

        string PrzypomnijNazwęUżytkownika()
        {
            if (Request.Cookies["imie"] != null) return Request.Cookies["imie"].Value;
            else return null;
        }
    }
}