﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using System.Drawing;
using System.Drawing.Drawing2D;
using System.Drawing.Imaging;

using System.IO;

namespace Zdjecia
{
    public partial class DodawanieZdjecia : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {

        }

        ZdjeciaDataContext bazaDanych = new ZdjeciaDataContext();
        const int maksymalnyRozmiarPliku = 2 * 1024 * 1024; //2MB
        const string katalogNaPrzeslanePliki = @"C:\Zdjecia_PobranePliki";
        const string katalogNaMiniatury = "~/Zdjecia_Miniatury";

        protected void Button1_Click(object sender, EventArgs e)
        {            
            string katalogNaPrzeslanyPlik = Path.Combine(katalogNaPrzeslanePliki, DropDownList1.SelectedValue);
            if (!Directory.Exists(katalogNaPrzeslanyPlik)) Directory.CreateDirectory(katalogNaPrzeslanyPlik);

            if (FileUpload1.HasFile)
            {
                //sprawdzanie czy plik graficzny
                string nazwaPliku = FileUpload1.FileName;
                string rozszerzeniePliku = Path.GetExtension(nazwaPliku);
                rozszerzeniePliku = rozszerzeniePliku.ToLower();
                if (!(rozszerzeniePliku == ".jpg" || rozszerzeniePliku == ".jpeg" || rozszerzeniePliku == ".jpe" ||
                    rozszerzeniePliku == ".gif" || rozszerzeniePliku == ".bmp"))
                {
                    Label1.Text += "<BR><FONT COLOR=magenta>Plik nie ma rozszerzenia wskazującego na plik graficzny (JPEG, GIF, BMP). Plik nie został przesłany.</FONT>";
                    return;
                }

                //sprawdzanie czy plik nie jest za duży
                int rozmiarPliku = FileUpload1.PostedFile.ContentLength;
                if (rozmiarPliku > maksymalnyRozmiarPliku)
                {
                    Label1.Text += "<BR><FONT COLOR=magenta>Plik " + nazwaPliku + " jest zbyt duży (" + rozmiarPliku + " bajtów) .</FONT>";
                    return;
                }

                //unikanie powtórzeń nazw
                string data = DateTime.Now.ToString().Replace(':', '_');
                string nazwaUżytkownika = HttpContext.Current.User.Identity.Name;
                nazwaPliku = "(" + data + ") [" + nazwaUżytkownika + "] " + nazwaPliku;

                //właściwe uploadowanie pliku
                string ścieżkaPliku = Path.Combine(katalogNaPrzeslanyPlik, nazwaPliku);
                try
                {
                    FileUpload1.SaveAs(ścieżkaPliku);
                    Label1.Text += "<BR><FONT COLOR=green>Plik został pomyślnie przesłany i zapisany jako " + ścieżkaPliku + " (rozmiar pliku: " + rozmiarPliku + " bajtów).</FONT>";

                    //tworzenie kopii - miniatury (JPEG)                    
                    string katalogNaMiniaturę = Path.Combine(katalogNaMiniatury, DropDownList1.SelectedValue);
                    string nazwaPlikuMiniatury="miniatura_" + Path.GetFileNameWithoutExtension(nazwaPliku) + ".jpg";
                    string urlPlikuMiniatury = Path.Combine(katalogNaMiniaturę, nazwaPlikuMiniatury);
                    string ścieżkaFizycznaKataloguNaMiniaturę = Server.MapPath(katalogNaMiniaturę);
                    if (!Directory.Exists(ścieżkaFizycznaKataloguNaMiniaturę)) Directory.CreateDirectory(ścieżkaFizycznaKataloguNaMiniaturę);                    
                    string ścieżkaFizycznaPlikuMiniatury = Server.MapPath(urlPlikuMiniatury);
                    //Label1.Text += "<BR>katalogNaMiniaturę=" + katalogNaMiniaturę;
                    //Label1.Text += "<BR>urlPlikuMiniatury=" + urlPlikuMiniatury;
                    //Label1.Text += "<BR>ścieżkaFizycznaKataloguNaMiniaturę=" + ścieżkaFizycznaKataloguNaMiniaturę;
                    //Label1.Text += "<BR>ścieżkaFizycznaPlikuMiniatury=" + ścieżkaFizycznaPlikuMiniatury;                    
                    int szerokość, wysokość;
                    PrzygorujMiniature(ścieżkaPliku, ścieżkaFizycznaPlikuMiniatury, out szerokość, out wysokość);

                    //wyświetlanie ostatnio dodanego obrazu
                    Image1.ImageUrl = urlPlikuMiniatury;
                    Image1.Visible = true;
                    Label2.Visible = true;

                    //dodanie zapisu do bazy danych
                    int idZdjecia=(bazaDanych.Zdjecies.Count() == 0) ? 0 : bazaDanych.Zdjecies.Max(zdjecie => zdjecie.ID) + 1;
                    Zdjecie noweZdjecie = new Zdjecie()
                    {
                        ID = idZdjecia,
                        ŚcieżkaPliku = ścieżkaPliku,
                        ŚcieżkaPlikuMiniatury = urlPlikuMiniatury,
                        Kategoria = DropDownList1.SelectedValue,
                        NazwaUżytkownika = nazwaUżytkownika,
                        DataUmieszczeniaWZbiorze = DateTime.Now,
                        Opis = TextBox1.Text,
                        Publiczne = CheckBox1.Checked,
                        Szerokość = szerokość,
                        Wysokość = wysokość
                    };
                    bazaDanych.Zdjecies.InsertOnSubmit(noweZdjecie);
                    bazaDanych.SubmitChanges();

                    Label1.Text += "<FONT COLOR=green> Unikalny identyfikator zdjęcia: " + noweZdjecie.ID + "</FONT>";
                }
                catch (Exception exc)
                {
                    Label1.Text += "<BR><FONT COLOR=red>Błąd podczas przesyłania: " + exc.Message + ".</FONT>";
                }
            }
            else
            {
                Label1.Text += "<BR><FONT COLOR=red>Musisz najpierw wybrać plik</FONT>";
            }
        }

        const int rozmiarMiniatury = 200;

        static private void PrzygorujMiniature(string nazwaOryginalnegoPliku, string nazwaPlikuMiniatury, out int szerokość, out int wysokość)
        {
            Bitmap oryginalnyObraz = new Bitmap(nazwaOryginalnegoPliku);

            //ustalanie rozmiarow
            if (oryginalnyObraz.Width > oryginalnyObraz.Height)
            {
                szerokość = rozmiarMiniatury;
                wysokość = rozmiarMiniatury * oryginalnyObraz.Height / oryginalnyObraz.Width;
            }
            else
            {
                wysokość = rozmiarMiniatury;
                szerokość = rozmiarMiniatury * oryginalnyObraz.Width / oryginalnyObraz.Height;
            }

            Bitmap miniatura = new Bitmap(szerokość, wysokość);

            //rysowanie zmniejszonego
            using (Graphics graphics = Graphics.FromImage(miniatura))
            {
                graphics.InterpolationMode = InterpolationMode.HighQualityBicubic;
                graphics.SmoothingMode = SmoothingMode.AntiAlias;
                graphics.PixelOffsetMode = PixelOffsetMode.HighQuality;
                graphics.DrawImage(oryginalnyObraz, 0, 0, szerokość, wysokość);
            }

            //zapis do pliku
            miniatura.Save(nazwaPlikuMiniatury, ImageFormat.Jpeg);
        }        
    }
}