﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.SessionState;

using System.IO;

namespace KsiegaGosci
{
    public class Global : System.Web.HttpApplication
    {
        public const string nazwaZmiennej_Wpisy = "wpisy";        
        public const string nazwaZmiennej_NazwaUżytkownika = "nazwaUżytkownika";

        const string nazwaPliku_Log = @"d:\KsiegaGosci.log";

        protected void Application_Start(object sender, EventArgs e)
        {
            Wpisy wpisy = new Wpisy();
            Application.Add(nazwaZmiennej_Wpisy, wpisy);
            Global.DopiszDoPlikuLog("Aplikacja uruchomiona - " + AppDomain.CurrentDomain.BaseDirectory);
        }

        protected void Session_Start(object sender, EventArgs e)
        {
            Global.DopiszDoPlikuLog("Utworzona nowa sesja - " + this.Request.UserHostAddress);
        }

        protected void Application_BeginRequest(object sender, EventArgs e)
        {

        }

        protected void Application_AuthenticateRequest(object sender, EventArgs e)
        {

        }

        protected void Application_Error(object sender, EventArgs e)
        {
            Global.DopiszDoPlikuLog("Błąd aplikacji - " + this.Request.UserHostAddress);
        }

        protected void Session_End(object sender, EventArgs e)
        {
            Global.DopiszDoPlikuLog("Sesja zakończona");
        }

        protected void Application_End(object sender, EventArgs e)
        {
            Global.DopiszDoPlikuLog("Aplikacja zamknięta");
        }

        static public void DopiszDoPlikuLog(string informacja)
        {
            if (File.Exists(nazwaPliku_Log)) File.Copy(nazwaPliku_Log, nazwaPliku_Log + ".bak", true);
                using (StreamWriter sw = new StreamWriter(nazwaPliku_Log, true))
                {
                    sw.WriteLine(DateTime.Now.ToString() + ": " + informacja);
                }
        }
    }
}