﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.SessionState;

using System.IO;

namespace KsiegaGosci
{
    public class Global : System.Web.HttpApplication
    {
        public const string nazwaZmiennej_Wpisy = "wpisy";

        const string nazwaPliku_WpisyTxt = @"d:\wpisy.txt";

        const string nazwaZmiennej_NazwaUżytkownika = "nazwaUżytkownika";

        protected void Application_Start(object sender, EventArgs e)
        {
            //tworzenie zmiennych
            Application.Add(nazwaZmiennej_Wpisy, new List<string>());

            //wczytywanie stanu aplikacji            
            WczytajZPlikuTxt();
        }

        protected void Session_Start(object sender, EventArgs e)
        {

        }

        protected void Application_BeginRequest(object sender, EventArgs e)
        {

        }

        protected void Application_AuthenticateRequest(object sender, EventArgs e)
        {

        }

        protected void Application_Error(object sender, EventArgs e)
        {

        }

        protected void Session_End(object sender, EventArgs e)
        {

        }

        static public bool ZapiszDoPlikuTxt(List<string> wpisy)
        {
            try
            {
                if (File.Exists(nazwaPliku_WpisyTxt)) File.Copy(nazwaPliku_WpisyTxt, nazwaPliku_WpisyTxt + ".bak", true);
                using (StreamWriter sw = new StreamWriter(nazwaPliku_WpisyTxt))
                {
                    foreach (string wpis in wpisy) sw.WriteLine(wpis.Replace("\r", ""));
                }
                return true;
            }
            catch
            {
                return false;
            }
        }

        static public bool DopiszDoPlikuTxt(string wpis)
        {
            try
            {
                if (File.Exists(nazwaPliku_WpisyTxt)) File.Copy(nazwaPliku_WpisyTxt, nazwaPliku_WpisyTxt + ".bak", true);
                using (StreamWriter sw = new StreamWriter(nazwaPliku_WpisyTxt, true))
                {
                    sw.WriteLine(wpis.Replace("\r", ""));
                }
                return true;
            }
            catch
            {
                return false;
            }
        }

        static public bool WczytajZPlikuTxt(List<string> wpisy)
        {
            if (!File.Exists(nazwaPliku_WpisyTxt)) return false;
            try
            {
                using (StreamReader sr = new StreamReader(nazwaPliku_WpisyTxt))
                {
                    string wpis;
                    while ((wpis = sr.ReadLine()) != null)
                        wpisy.Add(wpis);
                }
                return true;
            }
            catch
            {
                return false;
            }
        }

        bool WczytajZPlikuTxt()
        {
            List<string> wpisy = (List<string>)Application[nazwaZmiennej_Wpisy];
            return WczytajZPlikuTxt(wpisy);
        }        

        protected void Application_End(object sender, EventArgs e)
        {
            //List<string> wpisy = (List<string>)Application[nazwaZmiennej_Wpisy];
            //ZapiszDoPlikuTxt(wpisy);
        }
    }
}